/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.Material;
import de.gurkenlabs.litiengine.entities.Prop;
import de.gurkenlabs.litiengine.environment.Environment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.graphics.animation.EntityAnimationController;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropMapObjectLoader
extends MapObjectLoader {
    private static final Logger log = Logger.getLogger(PropMapObjectLoader.class.getName());
    private static final List<Class<? extends Prop>> customPropType = new CopyOnWriteArrayList<Class<? extends Prop>>();

    protected PropMapObjectLoader() {
        super(MapObjectType.PROP);
    }

    public static <T extends Prop> void registerCustomPropType(Class<T> propType) {
        customPropType.add(propType);
    }

    @Override
    public Collection<IEntity> load(Environment environment, IMapObject mapObject) {
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        if (!this.isMatchingType(mapObject)) {
            return entities;
        }
        Prop prop = this.createNewProp(mapObject, mapObject.getStringValue("spritesheetName", null));
        PropMapObjectLoader.loadDefaultProperties(prop, mapObject);
        prop.setMaterial(Material.get(mapObject.getStringValue("material", null)));
        entities.add(prop);
        return entities;
    }

    protected Prop createNewProp(IMapObject mapObject, String spriteSheet) {
        if (spriteSheet != null) {
            for (Class<? extends Prop> customProp : customPropType) {
                for (String prefix : EntityAnimationController.getDefaultSpritePrefixes(customProp)) {
                    Prop created;
                    if (!("prop-" + spriteSheet).equalsIgnoreCase(prefix) || (created = PropMapObjectLoader.createCustomProp(customProp, spriteSheet)) == null) continue;
                    return created;
                }
            }
        }
        return new Prop(spriteSheet);
    }

    private static Prop createCustomProp(Class<? extends Prop> customProp, String spriteSheet) {
        try {
            return customProp.getConstructor(String.class).newInstance(spriteSheet);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            try {
                Prop creature = customProp.getConstructor(new Class[0]).newInstance(new Object[0]);
                creature.setSpritesheetName(spriteSheet);
                return creature;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                log.log(Level.SEVERE, "Could not automatically create prop of type {0} because a matching constructor is missing.", new Object[]{customProp});
                log.log(Level.SEVERE, ex.getMessage(), ex);
                return null;
            }
        }
    }
}

