/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.MapArea;
import de.gurkenlabs.litiengine.environment.Environment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.MapUtilities;
import java.util.ArrayList;
import java.util.Collection;

public class MapAreaMapObjectLoader
extends MapObjectLoader {
    protected MapAreaMapObjectLoader() {
        super(MapObjectType.AREA);
    }

    @Override
    public Collection<IEntity> load(Environment environment, IMapObject mapObject) {
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        if (!this.isMatchingType(mapObject)) {
            return entities;
        }
        MapArea mapArea = new MapArea();
        MapAreaMapObjectLoader.loadDefaultProperties(mapArea, mapObject);
        MapAreaMapObjectLoader.initShape(mapArea, mapObject);
        entities.add(mapArea);
        return entities;
    }

    private static void initShape(MapArea area, IMapObject mapObject) {
        if (mapObject.isPolygon() || mapObject.isPolyline()) {
            area.setShape(MapUtilities.convertPolyshapeToPath(mapObject));
        } else if (mapObject.isEllipse()) {
            area.setShape(mapObject.getEllipse());
        }
    }
}

