/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Valign;
import de.gurkenlabs.litiengine.configuration.Quality;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.Environment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.xml.MapObject;
import de.gurkenlabs.litiengine.graphics.emitters.Emitter;
import de.gurkenlabs.litiengine.graphics.emitters.particles.ParticleType;
import de.gurkenlabs.litiengine.graphics.emitters.xml.EmitterData;
import de.gurkenlabs.litiengine.graphics.emitters.xml.ParticleParameter;
import de.gurkenlabs.litiengine.physics.Collision;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import de.gurkenlabs.litiengine.util.ColorHelper;
import java.util.ArrayList;
import java.util.Collection;

public class EmitterMapObjectLoader
extends MapObjectLoader {
    protected EmitterMapObjectLoader() {
        super(MapObjectType.EMITTER);
    }

    @Override
    public Collection<IEntity> load(Environment environment, IMapObject mapObject) {
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        if (!this.isMatchingType(mapObject)) {
            return entities;
        }
        EmitterData data = EmitterMapObjectLoader.createEmitterData(mapObject);
        Emitter emitter = new Emitter(data);
        EmitterMapObjectLoader.loadDefaultProperties(emitter, mapObject);
        entities.add(emitter);
        return entities;
    }

    public static EmitterData createEmitterData(IMapObject mapObject) {
        EmitterData data = new EmitterData();
        data.setWidth(mapObject.getWidth());
        data.setHeight(mapObject.getHeight());
        data.setSpawnRate(mapObject.getIntValue("emitterSpawnRate", 100));
        data.setSpawnAmount(mapObject.getIntValue("emitterSpawnAmount", 20));
        data.setUpdateRate(mapObject.getIntValue("emitterUpdateDelay", 40));
        data.setEmitterDuration(mapObject.getIntValue("emitterDuration", 0));
        data.setMaxParticles(mapObject.getIntValue("emitterMaxParticles", 400));
        data.setParticleType(mapObject.getEnumValue("emitterParticleType", ParticleType.class, EmitterData.DEFAULT_PARTICLE_TYPE));
        data.setColorVariance(mapObject.getFloatValue("emitterColorVariance", 0.0f));
        data.setAlphaVariance(mapObject.getFloatValue("emitterAlphaVariance", 0.0f));
        data.setOriginAlign(mapObject.getEnumValue("emitterOriginAlign", Align.class, EmitterData.DEFAULT_ORIGIN_ALIGN));
        data.setOriginValign(mapObject.getEnumValue("emitterOriginValign", Valign.class, EmitterData.DEFAULT_ORIGIN_VALIGN));
        data.setColors(mapObject.getCommaSeparatedStringValues("emitterColors", ColorHelper.encode(EmitterData.DEFAULT_COLOR)));
        data.setParticleOffsetX(new ParticleParameter(mapObject.getFloatValue("particleMinOffsetX", 0.0f), mapObject.getFloatValue("particleMaxOffsetX", 0.0f)));
        data.setParticleOffsetY(new ParticleParameter(mapObject.getFloatValue("particleMinOffsetY", 0.0f), mapObject.getFloatValue("particleMaxOffsetY", 0.0f)));
        data.setParticleWidth(new ParticleParameter(mapObject.getFloatValue("particleMinStartWidth", 0.0f), mapObject.getFloatValue("particleMaxStartWidth", 0.0f)));
        data.setParticleHeight(new ParticleParameter(mapObject.getFloatValue("particleMinStartHeight", 0.0f), mapObject.getFloatValue("particleMaxStartHeight", 0.0f)));
        data.setVelocityX(new ParticleParameter(mapObject.getFloatValue("particleMinVelocityX", 0.0f), mapObject.getFloatValue("particleMaxVelocityX", 0.0f)));
        data.setVelocityY(new ParticleParameter(mapObject.getFloatValue("particleMinVelocityY", 0.0f), mapObject.getFloatValue("particleMaxVelocityY", 0.0f)));
        data.setAccelerationX(new ParticleParameter(mapObject.getFloatValue("particleMinAccelerationX", 0.0f), mapObject.getFloatValue("particleMaxAccelerationX", 0.0f)));
        data.setAccelerationY(new ParticleParameter(mapObject.getFloatValue("particleMinAccelerationY", 0.0f), mapObject.getFloatValue("particleMaxAccelerationY", 0.0f)));
        data.setDeltaWidth(new ParticleParameter(mapObject.getFloatValue("particleMinDeltaWidth", 0.0f), mapObject.getFloatValue("particleMaxDeltaWidth", 0.0f)));
        data.setDeltaHeight(new ParticleParameter(mapObject.getFloatValue("particleMinDeltaHeight", 0.0f), mapObject.getFloatValue("particleMaxDeltaHeight", 0.0f)));
        data.setAngle(new ParticleParameter(mapObject.getFloatValue("particleMinAngle", 0.0f), mapObject.getFloatValue("particleMaxAngle", 0.0f)));
        data.setDeltaRotation(new ParticleParameter(mapObject.getFloatValue("particleMinDeltaAngle", 0.0f), mapObject.getFloatValue("particleMaxDeltaAngle", 0.0f)));
        data.setParticleTTL(new ParticleParameter(mapObject.getFloatValue("particleMinTTL", 0.0f), mapObject.getFloatValue("particleMaxTTL", 0.0f)));
        data.setCollision(mapObject.getEnumValue("collisionType", Collision.class, EmitterData.DEFAULT_COLLISION));
        data.setRequiredQuality(mapObject.getEnumValue("requiredQuality", Quality.class, EmitterData.DEFAULT_REQUIRED_QUALITY));
        data.setTexts(mapObject.getCommaSeparatedStringValues("particleTexts", "LITI"));
        data.setSpritesheet(mapObject.getStringValue("spritesheetName", null));
        data.setAnimateSprite(mapObject.getBoolValue("particleAnimateSprite", false));
        data.setLoopSprite(mapObject.getBoolValue("particleLoopSprite", false));
        data.setFade(mapObject.getBoolValue("particleFade", false));
        data.setFadeOnCollision(mapObject.getBoolValue("particleFadeOnCollision", false));
        data.setOutlineOnly(mapObject.getBoolValue("particleOutlineOnly", false));
        data.setAntiAliasing(mapObject.getBoolValue("particleAntiAliasing", false));
        return data;
    }

    public static void updateMapObject(EmitterData emitterData, IMapObject mo) {
        mo.setType(MapObjectType.EMITTER.toString());
        mo.setName(emitterData.getName());
        mo.setWidth(emitterData.getWidth());
        mo.setHeight(emitterData.getHeight());
        mo.setValue("emitterSpawnRate", emitterData.getSpawnRate());
        mo.setValue("emitterSpawnAmount", emitterData.getSpawnAmount());
        mo.setValue("emitterUpdateDelay", emitterData.getUpdateRate());
        mo.setValue("emitterDuration", emitterData.getEmitterDuration());
        mo.setValue("emitterMaxParticles", emitterData.getMaxParticles());
        mo.setValue("emitterParticleType", emitterData.getParticleType());
        mo.setValue("emitterColorVariance", emitterData.getColorVariance());
        mo.setValue("emitterAlphaVariance", emitterData.getAlphaVariance());
        mo.setValue("emitterOriginAlign", emitterData.getOriginAlign());
        mo.setValue("emitterOriginValign", emitterData.getOriginValign());
        String commaSeperatedColors = ArrayUtilities.join(emitterData.getColors());
        mo.setValue("emitterColors", commaSeperatedColors);
        mo.setValue("particleMinOffsetX", emitterData.getParticleOffsetX().getMinValue());
        mo.setValue("particleMinOffsetY", emitterData.getParticleOffsetY().getMinValue());
        mo.setValue("particleMinStartWidth", emitterData.getParticleWidth().getMinValue());
        mo.setValue("particleMinStartHeight", emitterData.getParticleHeight().getMinValue());
        mo.setValue("particleMinVelocityX", emitterData.getVelocityX().getMinValue());
        mo.setValue("particleMinVelocityY", emitterData.getVelocityY().getMinValue());
        mo.setValue("particleMinAccelerationX", emitterData.getAccelerationX().getMinValue());
        mo.setValue("particleMinAccelerationY", emitterData.getAccelerationY().getMinValue());
        mo.setValue("particleMinDeltaWidth", emitterData.getDeltaWidth().getMinValue());
        mo.setValue("particleMinDeltaHeight", emitterData.getDeltaHeight().getMinValue());
        mo.setValue("particleMinAngle", emitterData.getAngle().getMinValue());
        mo.setValue("particleMinDeltaAngle", emitterData.getDeltaAngle().getMinValue());
        mo.setValue("particleMinTTL", emitterData.getParticleTTL().getMinValue());
        mo.setValue("particleMaxOffsetX", emitterData.getParticleOffsetX().getMaxValue());
        mo.setValue("particleMaxOffsetY", emitterData.getParticleOffsetY().getMaxValue());
        mo.setValue("particleMaxStartWidth", emitterData.getParticleWidth().getMaxValue());
        mo.setValue("particleMaxStartHeight", emitterData.getParticleHeight().getMaxValue());
        mo.setValue("particleMaxVelocityX", emitterData.getVelocityX().getMaxValue());
        mo.setValue("particleMaxVelocityY", emitterData.getVelocityY().getMaxValue());
        mo.setValue("particleMaxAccelerationX", emitterData.getAccelerationX().getMaxValue());
        mo.setValue("particleMaxAccelerationY", emitterData.getAccelerationY().getMaxValue());
        mo.setValue("particleMaxDeltaWidth", emitterData.getDeltaWidth().getMaxValue());
        mo.setValue("particleMaxDeltaHeight", emitterData.getDeltaHeight().getMaxValue());
        mo.setValue("particleMaxAngle", emitterData.getAngle().getMaxValue());
        mo.setValue("particleMaxDeltaAngle", emitterData.getDeltaAngle().getMaxValue());
        mo.setValue("particleMaxTTL", emitterData.getParticleTTL().getMaxValue());
        mo.setValue("collisionType", emitterData.getCollision());
        mo.setValue("requiredQuality", emitterData.getRequiredQuality());
        String commaSeperatedTexts = ArrayUtilities.join(emitterData.getTexts());
        mo.setValue("particleTexts", commaSeperatedTexts);
        mo.setValue("spritesheetName", emitterData.getSpritesheet());
        mo.setValue("particleAnimateSprite", emitterData.isAnimatingSprite());
        mo.setValue("particleLoopSprite", emitterData.isLoopingSprite());
        mo.setValue("particleFade", emitterData.isFading());
        mo.setValue("particleFadeOnCollision", emitterData.isFadingOnCollision());
        mo.setValue("particleOutlineOnly", emitterData.isOutlineOnly());
        mo.setValue("particleAntiAliasing", emitterData.isAntiAliased());
    }

    public static IMapObject createMapObject(EmitterData emitterData) {
        MapObject newMapObject = new MapObject();
        EmitterMapObjectLoader.updateMapObject(emitterData, newMapObject);
        return newMapObject;
    }
}

