/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities.behavior;

import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.List;

public class Path {
    private final Path2D path2D;
    private final List<Point2D> points;
    private final Point2D start;
    private final Point2D target;

    public Path(Path2D path) {
        this.path2D = path;
        this.points = GeometricUtilities.getPoints(this.path2D);
        if (!this.points.isEmpty()) {
            this.start = this.points.get(0);
            this.target = this.points.get(this.points.size() - 1);
        } else {
            this.start = null;
            this.target = null;
        }
    }

    public Path(Point2D start, Point2D target, Path2D path, List<Point2D> points) {
        this.start = start;
        this.target = target;
        this.path2D = path;
        this.points = points;
    }

    public Path2D getPath() {
        return this.path2D;
    }

    public List<Point2D> getPoints() {
        return this.points;
    }

    public Point2D getStart() {
        return this.start;
    }

    public Point2D getTarget() {
        return this.target;
    }
}

