/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.entities.CollisionEntity;
import de.gurkenlabs.litiengine.entities.CollisionInfo;
import de.gurkenlabs.litiengine.entities.EntityInfo;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.TriggerActivatedListener;
import de.gurkenlabs.litiengine.entities.TriggerActivatingCondition;
import de.gurkenlabs.litiengine.entities.TriggerDeactivatedListener;
import de.gurkenlabs.litiengine.entities.TriggerEvent;
import de.gurkenlabs.litiengine.entities.TriggerListener;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import de.gurkenlabs.litiengine.environment.tilemap.TmxType;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

@CollisionInfo(collision=false)
@EntityInfo(renderType=RenderType.OVERLAY)
@TmxType(value=MapObjectType.TRIGGER)
public class Trigger
extends CollisionEntity
implements IUpdateable {
    private static final Logger log = Logger.getLogger(Trigger.class.getName());
    private final Collection<TriggerActivatedListener> activatedListeners = ConcurrentHashMap.newKeySet();
    private final Collection<TriggerDeactivatedListener> deactivatedListeners = ConcurrentHashMap.newKeySet();
    private final Collection<TriggerActivatingCondition> activatingConditions = ConcurrentHashMap.newKeySet();
    private final Collection<IEntity> collisionActivated = ConcurrentHashMap.newKeySet();
    private final List<Integer> activators = new CopyOnWriteArrayList<Integer>();
    private final List<Integer> targets = new CopyOnWriteArrayList<Integer>();
    @TmxProperty(name="triggerActivation")
    private TriggerActivation activationType;
    @TmxProperty(name="triggerOneTime")
    private boolean isOneTimeTrigger;
    @TmxProperty(name="triggermessage")
    private String message;
    @TmxProperty(name="triggerCooldown")
    private int cooldown;
    private long lastActivation;
    private boolean isActivated;

    public Trigger(TriggerActivation activation, String message) {
        this(activation, null, message);
    }

    public Trigger(TriggerActivation activation, String name, String message) {
        this(activation, name, message, false);
    }

    public Trigger(TriggerActivation activation, String message, boolean isOneTime) {
        this.message = message;
        this.isOneTimeTrigger = isOneTime;
        this.activationType = activation;
        this.setCollisionBoxWidth(this.getWidth());
        this.setCollisionBoxHeight(this.getHeight());
    }

    public Trigger(TriggerActivation activation, String name, String message, boolean isOneTime) {
        this(activation, message, isOneTime);
        this.setName(name);
    }

    public Trigger(TriggerActivation activation, String message, boolean isOneTime, int cooldown) {
        this(activation, message, isOneTime);
        this.setCooldown(cooldown);
    }

    public void addTriggerListener(TriggerListener listener) {
        this.activatedListeners.add(listener);
        this.activatingConditions.add(listener);
        this.deactivatedListeners.add(listener);
    }

    public void removeTriggerListener(TriggerListener listener) {
        this.activatedListeners.remove(listener);
        this.activatingConditions.remove(listener);
        this.deactivatedListeners.remove(listener);
    }

    public void addActivatedListener(TriggerActivatedListener listener) {
        this.activatedListeners.add(listener);
    }

    public void removeActivatedListener(TriggerActivatedListener listener) {
        this.activatedListeners.remove(listener);
    }

    public void addActivatingCondition(TriggerActivatingCondition condition) {
        this.activatingConditions.add(condition);
    }

    public void removeActivatingCondition(TriggerActivatingCondition condition) {
        this.activatingConditions.remove(condition);
    }

    public void addDeactivatedListener(TriggerDeactivatedListener listener) {
        this.deactivatedListeners.add(listener);
    }

    public void removeDeactivatedListener(TriggerDeactivatedListener listener) {
        this.deactivatedListeners.remove(listener);
    }

    public void addActivator(int mapId) {
        this.activators.add(mapId);
    }

    public void addActivator(IEntity activator) {
        this.activators.add(activator.getMapId());
    }

    public void addTarget(int mapId) {
        this.targets.add(mapId);
    }

    public void addTarget(IEntity target) {
        this.targets.add(target.getMapId());
    }

    public TriggerActivation getActivationType() {
        return this.activationType;
    }

    public List<Integer> getActivators() {
        return this.activators;
    }

    public String getMessage() {
        return this.message;
    }

    public List<Integer> getTargets() {
        return this.targets;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public boolean canTrigger(ICollisionEntity entity) {
        return entity.canCollideWith(this) && GeometricUtilities.intersects(this.getCollisionBox(), entity.getCollisionBox());
    }

    public boolean isOneTimeTrigger() {
        return this.isOneTimeTrigger;
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public boolean interact(IEntity sender) {
        if (this.activationType == TriggerActivation.COLLISION || sender == null) {
            return false;
        }
        if (this.activators.isEmpty() || this.activators.contains(sender.getMapId())) {
            return this.activate(sender, sender.getMapId());
        }
        log.log(Level.FINE, "[{1}] tried to activate trigger [{0}] but was not allowed so because it was not on the list of activators", new Object[]{this, sender.getMapId()});
        return false;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void setHeight(double height) {
        this.setCollisionBoxHeight(height);
        super.setHeight(height);
    }

    @Override
    public void setWidth(double width) {
        this.setCollisionBoxWidth(width);
        super.setWidth(width);
    }

    @Override
    public void setSize(double width, double height) {
        this.setCollisionBoxWidth(width);
        this.setCollisionBoxHeight(height);
        super.setSize(width, height);
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Override
    public void update() {
        if (Game.world().environment() == null || !this.isLoaded() || this.activationType != TriggerActivation.COLLISION) {
            return;
        }
        List<IEntity> collEntities = this.getEntitiesInCollisionBox();
        for (IEntity ent : collEntities) {
            if (this.collisionActivated.contains(ent)) continue;
            this.activate(ent, ent.getMapId());
        }
        Iterator<IEntity> iter = this.collisionActivated.iterator();
        while (iter.hasNext()) {
            IEntity ent;
            ent = iter.next();
            if (collEntities.contains(ent)) continue;
            List<Integer> triggerTargets = this.getTargets();
            if (triggerTargets.isEmpty()) {
                triggerTargets = new ArrayList<Integer>();
                triggerTargets.add(ent.getMapId());
            }
            TriggerEvent event = new TriggerEvent(this, ent, triggerTargets);
            for (TriggerDeactivatedListener listener : this.deactivatedListeners) {
                listener.deactivated(event);
            }
            iter.remove();
        }
    }

    private boolean activate(IEntity activator, int tar) {
        if (!this.isLoaded() || this.isOneTimeTrigger && this.isActivated || this.getActivationType() == TriggerActivation.COLLISION && activator != null && this.collisionActivated.contains(activator)) {
            return false;
        }
        if (this.getCooldown() > 0 && Game.time().since(this.lastActivation) < (long)this.getCooldown()) {
            return false;
        }
        List<Integer> triggerTargets = this.getTargets(tar);
        TriggerEvent te = new TriggerEvent(this, activator, triggerTargets);
        if (!this.checkActivationPredicates(te)) {
            return false;
        }
        this.isActivated = true;
        if (activator != null) {
            this.collisionActivated.add(activator);
        }
        Iterator<Object> iterator = triggerTargets.iterator();
        while (iterator.hasNext()) {
            int target = iterator.next();
            IEntity entity = this.getEnvironment().get(target);
            if (entity == null) {
                log.log(Level.WARNING, "trigger [{0}] was activated, but the trigger target [{1}] could not be found on the environment", new Object[]{this, target});
                continue;
            }
            entity.sendMessage(this, this.message);
        }
        for (TriggerActivatedListener listener : this.activatedListeners) {
            listener.activated(te);
        }
        if (this.isOneTimeTrigger) {
            this.getEnvironment().remove(this);
        }
        this.lastActivation = Game.time().now();
        return true;
    }

    private boolean checkActivationPredicates(TriggerEvent te) {
        for (TriggerActivatingCondition condition : this.activatingConditions) {
            String result = condition.canActivate(te);
            if (result == null || result.isEmpty()) continue;
            te.getEntity().sendMessage(this, result);
            log.log(Level.FINE, "trigger [{0}] was not activated. Reason: [{1}])", new Object[]{this, result});
            return false;
        }
        return true;
    }

    private List<IEntity> getEntitiesInCollisionBox() {
        CopyOnWriteArrayList<IEntity> collEntities = new CopyOnWriteArrayList<IEntity>();
        for (ICollisionEntity coll : Game.physics().getCollisionEntities()) {
            if (coll == this || !coll.canCollideWith(this) || !this.activators.isEmpty() && !this.activators.contains(coll.getMapId()) || !coll.getCollisionBox().intersects(this.getCollisionBox())) continue;
            collEntities.add(coll);
        }
        return collEntities;
    }

    private List<Integer> getTargets(int optionalTarget) {
        List<Integer> localTargets = this.getTargets();
        if (localTargets.isEmpty()) {
            localTargets = new ArrayList<Integer>();
            if (optionalTarget > 0) {
                localTargets.add(optionalTarget);
            }
        }
        return localTargets;
    }

    public static enum TriggerActivation {
        COLLISION,
        INTERACT;

    }
}

