/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util;

import java.util.concurrent.TimeUnit;

public final class TimeUtilities {
    private TimeUtilities() {
        throw new UnsupportedOperationException();
    }

    public static double nanoToMs(long nano) {
        return (double)nano / 1000000.0;
    }

    public static long getDays(long ms) {
        return TimeUnit.MILLISECONDS.toDays(ms);
    }

    public static long getHours(long ms) {
        return TimeUnit.MILLISECONDS.toHours(ms);
    }

    public static long getMinutes(long ms) {
        return TimeUnit.MILLISECONDS.toMinutes(ms);
    }

    public static long getSeconds(long ms) {
        return TimeUnit.MILLISECONDS.toSeconds(ms);
    }

    public static long getRemainingDays(long ms) {
        return ms / 1000L / 60L / 60L / 24L % 365L;
    }

    public static long getRemainingHours(long ms) {
        return ms / 1000L / 60L / 60L % 24L;
    }

    public static long getRemainingMinutes(long ms) {
        return ms / 1000L / 60L % 60L;
    }

    public static long getRemainingSeconds(long ms) {
        return ms / 1000L % 60L;
    }

    public static long getRemainingMilliSeconds(long ms) {
        return ms % 1000L;
    }

    public static String toTimerFormat(long duration, TimerFormat format) {
        long h = TimeUtilities.getRemainingHours(duration);
        long m = TimeUtilities.getRemainingMinutes(duration);
        long s = TimeUtilities.getRemainingSeconds(duration);
        long ms = TimeUtilities.getRemainingMilliSeconds(duration);
        switch (format.ordinal()) {
            case 1: {
                return String.format(format.getFormatString(), h, m, s);
            }
            case 10: {
                return String.format(format.getFormatString(), h, m, s, ms);
            }
            case 11: {
                return String.format(format.getFormatString(), h, m, s, ms / 100L);
            }
            case 2: {
                return String.format(format.getFormatString(), m, s, ms);
            }
            case 3: {
                return String.format(format.getFormatString(), m, s, ms / 100L);
            }
            case 4: 
            case 7: {
                return String.format(format.getFormatString(), s, ms);
            }
            case 5: 
            case 8: {
                return String.format(format.getFormatString(), s, ms / 10L);
            }
            case 6: 
            case 9: {
                return String.format(format.getFormatString(), s, ms / 100L);
            }
        }
        return Long.toString(ms);
    }

    public static enum TimerFormat {
        UNDEFINED(null),
        HH_MM_SS("%02d:%02d:%02d"),
        MM_SS_000("%02d:%02d.%03d"),
        MM_SS_0("%02d:%02d.%01d"),
        SS_000("%02d.%03d"),
        SS_00("%02d.%02d"),
        SS_0("%02d.%01d"),
        S_000("%01d.%03d"),
        S_00("%01d.%02d"),
        S_0("%01d.%01d"),
        HH_MM_SS_000("%02d:%02d:%02d.%03d"),
        HH_MM_SS_0("%02d:%02d:%02d.%01d");

        private final String formatString;

        private TimerFormat(String formatString) {
            this.formatString = formatString;
        }

        public String getFormatString() {
            return this.formatString;
        }
    }
}

