/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui.screens;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.gui.screens.Screen;
import de.gurkenlabs.litiengine.gui.screens.ScreenChangedEvent;
import de.gurkenlabs.litiengine.gui.screens.ScreenChangedListener;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ScreenManager {
    private static final Logger log = Logger.getLogger(ScreenManager.class.getName());
    private static final int DEFAULT_CHANGE_COOLDOWN = 200;
    private final List<ScreenChangedListener> screenChangedListeners;
    private final List<Screen> screens;
    private Screen currentScreen;
    private int changeCooldown = 200;
    private long lastScreenChange = 0L;

    public ScreenManager() {
        if (Game.screens() != null) {
            throw new UnsupportedOperationException("Never initialize a ScreenManager manually. Use Game.screens() instead.");
        }
        this.screenChangedListeners = new CopyOnWriteArrayList<ScreenChangedListener>();
        this.screens = new CopyOnWriteArrayList<Screen>();
    }

    public void addScreenChangedListener(ScreenChangedListener listener) {
        this.screenChangedListeners.add(listener);
    }

    public void removeScreenChangedListener(ScreenChangedListener listener) {
        this.screenChangedListeners.remove(listener);
    }

    public void add(Screen screen) {
        screen.setWidth(Game.window().getWidth());
        screen.setHeight(Game.window().getHeight());
        this.screens.add(screen);
        if (this.current() == null) {
            this.display(screen);
        }
    }

    public void remove(Screen screen) {
        this.screens.remove(screen);
        if (this.current() == screen) {
            if (!this.screens.isEmpty()) {
                this.display(this.screens.get(0));
            } else {
                this.display((Screen)null);
            }
        }
    }

    public void display(Screen screen) {
        if (Game.hasStarted() && Game.time().since(this.lastScreenChange) < (long)this.getChangeCooldown()) {
            log.log(Level.INFO, "Skipping displaying of screen {0} because screen changing is currently on cooldown.", screen != null ? screen.getName() : "");
            return;
        }
        Screen previous = this.current();
        if (previous != null) {
            previous.suspend();
        }
        if (screen != null && !this.screens.contains(screen)) {
            this.screens.add(screen);
        }
        this.currentScreen = screen;
        if (!Game.isInNoGUIMode() && this.current() != null) {
            this.current().prepare();
        }
        this.lastScreenChange = Game.loop().getTicks();
        ScreenChangedEvent event = new ScreenChangedEvent(this.current(), previous);
        for (ScreenChangedListener listener : this.screenChangedListeners) {
            listener.changed(event);
        }
    }

    public void display(String screenName) {
        if (this.current() != null && this.current().getName().equalsIgnoreCase(screenName)) {
            log.log(Level.INFO, "Skipping displaying of screen {0} because it is already the current screen.", screenName);
            return;
        }
        if (this.screens.stream().noneMatch(element -> element.getName().equalsIgnoreCase(screenName))) {
            log.log(Level.WARNING, "Could not display the screen {0} because there is no screen with the specified name.", screenName);
            return;
        }
        Screen screen = this.get(screenName);
        if (screen == null) {
            return;
        }
        this.display(screen);
    }

    public Screen get(String screenName) {
        Optional<Screen> opt = this.screens.stream().filter(element -> element.getName().equalsIgnoreCase(screenName)).findFirst();
        return opt.orElse(null);
    }

    public Collection<Screen> getAll() {
        return this.screens;
    }

    public Screen current() {
        return this.currentScreen;
    }

    public int getChangeCooldown() {
        return this.changeCooldown;
    }

    public void setChangeCooldown(int changeCooldown) {
        this.changeCooldown = changeCooldown;
    }
}

