/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui.screens;

import java.awt.Dimension;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Resolution {
    private static final Logger log = Logger.getLogger(Resolution.class.getName());
    private final int width;
    private final int height;
    private final Dimension dimension;
    private final Ratio ratio;

    private Resolution(int width, int height, Ratio ratio) {
        this.width = width;
        this.height = height;
        this.dimension = new Dimension(this.getWidth(), this.getHeight());
        this.ratio = ratio;
    }

    public static Resolution custom(int width, int height, String resolutionName) {
        return new Resolution(width, height, new Ratio(width, height, resolutionName));
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public String toDimensionString() {
        return this.toDimensionString("x");
    }

    public String toDimensionString(String delimiter) {
        return this.getWidth() + delimiter + this.getHeight();
    }

    public String toString() {
        return this.toDimensionString();
    }

    public Ratio getRatio() {
        return this.ratio;
    }

    public static class Ratio {
        private final String name;
        private final int x;
        private final int y;

        protected Ratio(int x, int y) {
            this(x, y, x + ":" + y);
        }

        protected Ratio(int x, int y, String name) {
            this.x = x;
            this.y = y;
            this.name = name;
        }

        protected static List<Resolution> getAll(Class<?> clz) {
            ArrayList<Resolution> resolutions = new ArrayList<Resolution>();
            for (Field field : clz.getDeclaredFields()) {
                if (field.getType() != Resolution.class || !Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
                try {
                    resolutions.add((Resolution)field.get(null));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            return resolutions;
        }

        public String getName() {
            return this.name;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class Ratio16x10
    extends Ratio {
        public static final Resolution RES_720x480 = new Resolution(720, 480, new Ratio16x10());
        public static final Resolution RES_1280x800 = new Resolution(1280, 800, new Ratio16x10());
        public static final Resolution RES_1440x900 = new Resolution(1440, 900, new Ratio16x10());
        public static final Resolution RES_1680x1050 = new Resolution(1680, 1050, new Ratio16x10());
        public static final Resolution RES_1920x1200 = new Resolution(1920, 1200, new Ratio16x10());

        private Ratio16x10() {
            super(16, 10);
        }

        public static List<Resolution> getAll() {
            return Ratio16x10.getAll(Ratio16x10.class);
        }
    }

    public static class Ratio16x9
    extends Ratio {
        public static final Resolution RES_1280x720 = new Resolution(1280, 720, new Ratio16x9());
        public static final Resolution RES_1360x768 = new Resolution(1360, 768, new Ratio16x9());
        public static final Resolution RES_1366x768 = new Resolution(1366, 768, new Ratio16x9());
        public static final Resolution RES_1536x864 = new Resolution(1536, 864, new Ratio16x9());
        public static final Resolution RES_1600x900 = new Resolution(1600, 900, new Ratio16x9());
        public static final Resolution RES_1920x1080 = new Resolution(1920, 1080, new Ratio16x9());
        public static final Resolution RES_2560x1440 = new Resolution(2560, 1440, new Ratio16x9());

        private Ratio16x9() {
            super(16, 9);
        }

        public static List<Resolution> getAll() {
            return Ratio16x9.getAll(Ratio16x9.class);
        }
    }

    public static class Ratio5x4
    extends Ratio {
        public static final Resolution RES_1280x1024 = new Resolution(1280, 1024, new Ratio5x4());

        private Ratio5x4() {
            super(5, 4);
        }

        public static List<Resolution> getAll() {
            return Ratio5x4.getAll(Ratio5x4.class);
        }
    }

    public static class Ratio4x3
    extends Ratio {
        public static final Resolution RES_640x480 = new Resolution(640, 480, new Ratio4x3());
        public static final Resolution RES_720x576 = new Resolution(720, 576, new Ratio4x3());
        public static final Resolution RES_800x600 = new Resolution(800, 600, new Ratio4x3());
        public static final Resolution RES_1024x768 = new Resolution(1024, 768, new Ratio4x3());
        public static final Resolution RES_1152x864 = new Resolution(1152, 864, new Ratio4x3());
        public static final Resolution RES_1280x960 = new Resolution(1280, 960, new Ratio4x3());
        public static final Resolution RES_1600x1200 = new Resolution(1600, 1200, new Ratio4x3());
        public static final Resolution RES_1920x1440 = new Resolution(1920, 1440, new Ratio4x3());

        private Ratio4x3() {
            super(4, 3);
        }

        public static List<Resolution> getAll() {
            return Ratio4x3.getAll(Ratio4x3.class);
        }
    }
}

