/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.animation;

import de.gurkenlabs.litiengine.entities.Prop;
import de.gurkenlabs.litiengine.entities.PropState;
import de.gurkenlabs.litiengine.entities.Rotation;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.graphics.animation.Animation;
import de.gurkenlabs.litiengine.graphics.animation.EntityAnimationController;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.util.Imaging;
import java.awt.image.BufferedImage;
import java.util.Optional;

public class PropAnimationController<T extends Prop>
extends EntityAnimationController<T> {
    public static final String PROP_IDENTIFIER = "prop-";

    public PropAnimationController(T prop) {
        super(prop);
        this.setDefault(PropAnimationController.createAnimation((Prop)this.getEntity(), PropState.INTACT));
        this.add(PropAnimationController.createAnimation((Prop)this.getEntity(), PropState.DAMAGED));
        this.add(PropAnimationController.createAnimation((Prop)this.getEntity(), PropState.DESTROYED));
    }

    public static String getSpriteName(Prop prop, boolean appendState) {
        return PropAnimationController.getSpriteName(prop, prop.getState(), appendState);
    }

    public static String getSpriteName(Prop prop, PropState state, boolean appendState) {
        StringBuilder sb = new StringBuilder(PROP_IDENTIFIER);
        sb.append(prop.getSpritesheetName());
        if (appendState) {
            sb.append("-");
            sb.append(state.spriteString());
        }
        return sb.toString();
    }

    @Override
    public BufferedImage getCurrentImage() {
        Animation animation = this.getCurrent();
        if (animation == null || animation.getSpritesheet() == null) {
            return null;
        }
        Object cacheKey = this.buildCurrentCacheKey();
        cacheKey = (String)cacheKey + "_" + ((Prop)this.getEntity()).isAddShadow();
        cacheKey = (String)cacheKey + "_" + String.valueOf((Object)((Prop)this.getEntity()).getState());
        cacheKey = (String)cacheKey + "_" + String.valueOf((Object)((Prop)this.getEntity()).getSpriteRotation());
        cacheKey = (String)cacheKey + "_" + ((Prop)this.getEntity()).flipHorizontally();
        cacheKey = (String)cacheKey + "_" + ((Prop)this.getEntity()).flipVertically();
        Optional opt = Resources.images().tryGet((String)cacheKey);
        if (opt.isPresent()) {
            return (BufferedImage)opt.get();
        }
        BufferedImage currentImage = super.getCurrentImage();
        if (currentImage == null) {
            return null;
        }
        if (((Prop)this.getEntity()).getSpriteRotation() != Rotation.NONE) {
            currentImage = Imaging.rotate(currentImage, ((Prop)this.getEntity()).getSpriteRotation());
        }
        if (((Prop)this.getEntity()).flipHorizontally()) {
            currentImage = Imaging.horizontalFlip(currentImage);
        }
        if (((Prop)this.getEntity()).flipVertically()) {
            currentImage = Imaging.verticalFlip(currentImage);
        }
        if (!((Prop)this.getEntity()).isAddShadow()) {
            return currentImage;
        }
        int ShadowYOffset = currentImage.getHeight();
        BufferedImage shadow = Imaging.addShadow(currentImage, 0, ShadowYOffset);
        Resources.images().add((String)cacheKey, shadow);
        return shadow;
    }

    @Override
    public void update() {
        super.update();
        this.play(((Prop)this.getEntity()).getState().spriteString());
    }

    @Override
    public boolean isAutoScaling() {
        return ((Prop)this.getEntity()).isScaling();
    }

    private static Animation createAnimation(Prop prop, PropState state) {
        Spritesheet spritesheet = PropAnimationController.findSpriteSheet(prop, state);
        if (spritesheet == null) {
            return null;
        }
        return new Animation(state.spriteString(), spritesheet, true, true, Resources.spritesheets().getCustomKeyFrameDurations(spritesheet.getName()));
    }

    private static Spritesheet findSpriteSheet(Prop prop, PropState state) {
        if (prop == null || prop.getSpritesheetName() == null || prop.getSpritesheetName().isEmpty()) {
            return null;
        }
        Spritesheet opt = Resources.spritesheets().get(PropAnimationController.getSpriteName(prop, state, true));
        if (opt != null) {
            return opt;
        }
        return Resources.spritesheets().get(PropAnimationController.getSpriteName(prop, state, false));
    }
}

