/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.environment.tilemap.ITileAnimation;
import de.gurkenlabs.litiengine.environment.tilemap.ITileAnimationFrame;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Frame;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.List;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class TileAnimation
implements ITileAnimation {
    @XmlElement(name="frame", type=Frame.class)
    private List<ITileAnimationFrame> frames;
    private transient int totalDuration;

    @Override
    public List<ITileAnimationFrame> getFrames() {
        return this.frames;
    }

    @Override
    public int getTotalDuration() {
        if (this.totalDuration > 0) {
            return this.totalDuration;
        }
        if (this.getFrames().isEmpty()) {
            return 0;
        }
        for (ITileAnimationFrame frame : this.getFrames()) {
            if (frame == null) continue;
            this.totalDuration += frame.getDuration();
        }
        return this.totalDuration;
    }

    @Override
    public ITileAnimationFrame getCurrentFrame() {
        long time = Game.time().sinceEnvironmentLoad() % (long)this.getTotalDuration();
        for (ITileAnimationFrame frame : this.getFrames()) {
            if ((time -= (long)frame.getDuration()) > 0L) continue;
            return frame;
        }
        throw new AssertionError();
    }
}

