/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.Environment;
import de.gurkenlabs.litiengine.environment.tilemap.IGroupLayer;
import de.gurkenlabs.litiengine.environment.tilemap.IImageLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ILayer;
import de.gurkenlabs.litiengine.environment.tilemap.ILayerList;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ITile;
import de.gurkenlabs.litiengine.environment.tilemap.ITileLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ITileOffset;
import de.gurkenlabs.litiengine.environment.tilemap.LayerRenderEvent;
import de.gurkenlabs.litiengine.graphics.ImageRenderer;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.resources.Resources;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class MapRenderer {
    private static Collection<LayerRenderedListener> layerRenderedListeners = ConcurrentHashMap.newKeySet();
    private static Collection<LayerRenderCondition> layerRenderConditions = ConcurrentHashMap.newKeySet();

    private MapRenderer() {
        throw new UnsupportedOperationException();
    }

    public static void onLayerRendered(LayerRenderedListener listener) {
        layerRenderedListeners.add(listener);
    }

    public static void removeLayerRenderedListener(LayerRenderedListener listener) {
        layerRenderedListeners.remove(listener);
    }

    public static void addLayerRenderCondition(LayerRenderCondition condition) {
        layerRenderConditions.add(condition);
    }

    public static void removeLayerRenderCondition(LayerRenderCondition condition) {
        layerRenderConditions.remove(condition);
    }

    public static void render(Graphics2D g, IMap map, Rectangle2D viewport, RenderType ... renderTypes) {
        MapRenderer.renderLayers(g, map, map, viewport, null, renderTypes, 1.0f);
    }

    public static void render(Graphics2D g, IMap map, Rectangle2D viewport, Environment env, RenderType ... renderTypes) {
        MapRenderer.renderLayers(g, map, map, viewport, env, renderTypes, 1.0f);
    }

    private static void renderLayers(Graphics2D g, IMap map, ILayerList layers, Rectangle2D viewport, Environment env, RenderType[] renderTypes, float opacity) {
        List<ILayer> renderLayers = layers.getRenderLayers();
        for (ILayer layer : renderLayers) {
            Collection<IEntity> entities;
            if (layer == null || !MapRenderer.shouldBeRendered(g, map, layer, renderTypes)) continue;
            float layerOpacity = layer.getOpacity() * opacity;
            if (layer instanceof ITileLayer) {
                MapRenderer.renderTileLayer(g, (ITileLayer)layer, map, viewport, layerOpacity);
            }
            if (env != null && layer instanceof IMapObjectLayer && (entities = env.getEntities((IMapObjectLayer)layer)) != null) {
                Game.graphics().renderEntities(g, entities, layer.getRenderType() == RenderType.NORMAL);
            }
            if (layer instanceof IImageLayer) {
                MapRenderer.renderImageLayer(g, (IImageLayer)layer, map, viewport, layerOpacity);
            }
            if (!(layer instanceof IGroupLayer)) continue;
            MapRenderer.renderLayers(g, map, (IGroupLayer)layer, viewport, env, renderTypes, layerOpacity);
        }
    }

    private static void renderTileLayer(Graphics2D g, ITileLayer layer, IMap map, Rectangle2D viewport, float opacity) {
        g.setComposite(AlphaComposite.getInstance(3, opacity));
        if (map.getRenderOrder().btt) {
            for (y = map.getHeight() - 1; y >= 0; --y) {
                MapRenderer.drawRow(g, layer, y, map, viewport);
            }
        } else {
            for (y = 0; y < map.getHeight(); ++y) {
                MapRenderer.drawRow(g, layer, y, map, viewport);
            }
        }
        LayerRenderEvent event = new LayerRenderEvent(g, map, layer);
        for (LayerRenderedListener listener : layerRenderedListeners) {
            listener.rendered(event);
        }
    }

    private static void drawRow(Graphics2D g, ITileLayer layer, int y, IMap map, Rectangle2D viewport) {
        if (map.getRenderOrder().rtl) {
            for (int x = map.getWidth() - 1; x >= 0; --x) {
                MapRenderer.drawTile(g, layer, x, y, map, viewport);
            }
        } else {
            for (int x = 0; x < map.getWidth(); ++x) {
                MapRenderer.drawTile(g, layer, x, y, map, viewport);
            }
        }
    }

    private static void drawTile(Graphics2D g, ITileLayer layer, int x, int y, IMap map, Rectangle2D viewport) {
        ITile tile = layer.getTile(x, y);
        if (tile == null) {
            return;
        }
        BufferedImage image = tile.getImage();
        if (image != null) {
            Point p = map.getOrientation().getLocation(x, y, map);
            p.y -= image.getHeight();
            ITileOffset offset = tile.getTilesetEntry().getTileset().getTileOffset();
            if (offset != null) {
                p.x += offset.getX();
                p.y += offset.getY();
            }
            if (viewport.intersects(p.x, p.y, image.getWidth(), image.getHeight())) {
                ImageRenderer.render(g, image, (double)p.x - viewport.getX(), (double)p.y - viewport.getY());
            }
        }
    }

    protected static boolean shouldBeRendered(Graphics2D g, IMap map, ILayer layer, RenderType[] renderTypes) {
        LayerRenderEvent event = new LayerRenderEvent(g, map, layer);
        for (LayerRenderCondition condition : layerRenderConditions) {
            if (condition.canRender(event)) continue;
            return false;
        }
        if (renderTypes == null || renderTypes.length == 0 || layer instanceof IGroupLayer) {
            return MapRenderer.isVisible(layer);
        }
        for (RenderType alloc : renderTypes) {
            if (alloc != layer.getRenderType()) continue;
            return MapRenderer.isVisible(layer);
        }
        return false;
    }

    protected static boolean isVisible(ILayer layer) {
        return layer.isVisible() && layer.getOpacity() > 0.0f;
    }

    protected static void renderImageLayer(Graphics2D g, IImageLayer layer, IMap map, Rectangle2D viewport, float opacity) {
        Spritesheet sprite = Resources.spritesheets().get(layer.getImage().getSource());
        BufferedImage img = sprite == null ? (BufferedImage)Resources.images().get(layer.getImage().getAbsoluteSourcePath()) : sprite.getImage();
        if (img == null) {
            return;
        }
        Composite oldComp = g.getComposite();
        AlphaComposite ac = AlphaComposite.getInstance(3, opacity);
        g.setComposite(ac);
        double viewportOffsetX = (double)layer.getOffset().x - viewport.getX();
        double viewportOffsetY = (double)layer.getOffset().y - viewport.getY();
        ImageRenderer.render(g, img, viewportOffsetX, viewportOffsetY);
        g.setComposite(oldComp);
        LayerRenderEvent event = new LayerRenderEvent(g, map, layer);
        for (LayerRenderedListener listener : layerRenderedListeners) {
            listener.rendered(event);
        }
    }

    @FunctionalInterface
    public static interface LayerRenderedListener
    extends EventListener {
        public void rendered(LayerRenderEvent var1);
    }

    @FunctionalInterface
    public static interface LayerRenderCondition
    extends EventListener {
        public boolean canRender(LayerRenderEvent var1);
    }
}

