/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.StaticShadow;
import de.gurkenlabs.litiengine.environment.Environment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.graphics.StaticShadowType;
import java.util.ArrayList;
import java.util.Collection;

public class StaticShadowMapObjectLoader
extends MapObjectLoader {
    protected StaticShadowMapObjectLoader() {
        super(MapObjectType.STATICSHADOW);
    }

    @Override
    public Collection<IEntity> load(Environment environment, IMapObject mapObject) {
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        if (!this.isMatchingType(mapObject)) {
            return entities;
        }
        StaticShadowType type = mapObject.getEnumValue("shadowType", StaticShadowType.class, StaticShadowType.DOWN);
        int offset = mapObject.getIntValue("shadowOffset", 10);
        StaticShadow shadow = this.createStaticShadow(mapObject, type, offset);
        StaticShadowMapObjectLoader.loadDefaultProperties(shadow, mapObject);
        shadow.setOffset(offset);
        entities.add(shadow);
        return entities;
    }

    protected StaticShadow createStaticShadow(IMapObject mapObject, StaticShadowType type, int offset) {
        return new StaticShadow(type, offset);
    }
}

