/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.IMapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.ICustomProperty;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectProperty;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.util.ReflectionUtilities;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class MapObjectLoader
implements IMapObjectLoader {
    private static final Logger log = Logger.getLogger(MapObjectLoader.class.getName());
    private final String mapObjectType;

    protected MapObjectLoader(String mapObjectType) {
        this.mapObjectType = mapObjectType;
    }

    protected MapObjectLoader(MapObjectType mapObjectType) {
        this.mapObjectType = mapObjectType.name();
    }

    @Override
    public String getMapObjectType() {
        return this.mapObjectType;
    }

    public static void loadDefaultProperties(IEntity entity, IMapObject mapObject) {
        RenderType renderType;
        String tagsString;
        entity.setMapId(mapObject.getId());
        entity.setWidth(mapObject.getWidth());
        entity.setHeight(mapObject.getHeight());
        entity.setName(mapObject.getName());
        entity.setLocation(mapObject.getLocation());
        if (mapObject.hasCustomProperty("renderWithLayer")) {
            entity.setRenderWithLayer(mapObject.getBoolValue("renderWithLayer"));
        }
        if ((tagsString = mapObject.getStringValue("tags")) != null && tagsString.trim().length() > 0) {
            String[] tags;
            for (String rawTag : tags = tagsString.split(",")) {
                String tag = rawTag.trim().replaceAll("[^A-Za-z0-9\\-\\_]", "");
                if (tag == null || tag.isEmpty()) continue;
                entity.addTag(tag);
            }
        }
        if ((renderType = mapObject.getEnumValue("renderType", RenderType.class)) != null) {
            entity.setRenderType(renderType);
        }
        MapObjectLoader.loadCustomMapObjectProperties(entity, mapObject);
        mapObject.getProperties().forEach((name, property) -> {
            if (MapObjectProperty.isCustom(name)) {
                entity.getProperties().setValue((String)name, (ICustomProperty)property);
            }
        });
    }

    @Override
    public void afterLoad(Collection<IEntity> entities, IMapObject mapObject) {
        for (IEntity entity : entities) {
            this.callAfterTmxUnmarshal(entity, mapObject);
        }
    }

    protected boolean isMatchingType(IMapObject mapObject) {
        if (!mapObject.getType().equalsIgnoreCase(this.getMapObjectType())) {
            log.log(Level.SEVERE, "Cannot load a mapobject of the type [{0}] with a loader of type [{1}].", new Object[]{mapObject.getType(), this.getClass()});
            return false;
        }
        return true;
    }

    private static void loadCustomMapObjectProperties(IEntity entity, IMapObject mapObject) {
        for (Field field : ReflectionUtilities.getAllFields(new ArrayList<Field>(), entity.getClass())) {
            String value;
            TmxProperty property = field.getAnnotation(TmxProperty.class);
            if (property == null || (value = mapObject.getStringValue(property.name(), null)) == null || ReflectionUtilities.setFieldValue(field.getDeclaringClass(), entity, field.getName(), value)) continue;
            log.warning("entity #" + entity.getMapId() + ": value \"" + value + "\" for custom property " + property.name() + " could not be set.");
        }
    }

    private void callAfterTmxUnmarshal(IEntity entity, IMapObject mapObject) {
        Method afterTmxUnmarshal = ReflectionUtilities.getMethod("afterTmxUnmarshal", entity.getClass(), IMapObject.class);
        if (afterTmxUnmarshal == null) {
            return;
        }
        afterTmxUnmarshal.setAccessible(true);
        try {
            afterTmxUnmarshal.invoke((Object)entity, mapObject);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.log(Level.SEVERE, "Could not invoke afterTmxUnmarshal method on type [{0}]: {1}", new Object[]{entity.getClass().getName(), e.getMessage()});
        }
    }
}

