/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.environment.Environment;
import de.gurkenlabs.litiengine.environment.EnvironmentListener;
import de.gurkenlabs.litiengine.environment.EnvironmentLoadedListener;
import de.gurkenlabs.litiengine.environment.EnvironmentUnloadedListener;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.graphics.Camera;
import de.gurkenlabs.litiengine.graphics.ICamera;
import de.gurkenlabs.litiengine.resources.Resources;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;

public final class GameWorld
implements IUpdateable {
    private final List<EnvironmentListener> listeners = new CopyOnWriteArrayList<EnvironmentListener>();
    private final List<EnvironmentLoadedListener> loadedListeners = new CopyOnWriteArrayList<EnvironmentLoadedListener>();
    private final List<EnvironmentUnloadedListener> unloadedListeners = new CopyOnWriteArrayList<EnvironmentUnloadedListener>();
    private final Map<String, Collection<EnvironmentListener>> environmentListeners = new ConcurrentHashMap<String, Collection<EnvironmentListener>>();
    private final Map<String, Collection<EnvironmentLoadedListener>> environmentLoadedListeners = new ConcurrentHashMap<String, Collection<EnvironmentLoadedListener>>();
    private final Map<String, Collection<EnvironmentUnloadedListener>> environmentUnloadedListeners = new ConcurrentHashMap<String, Collection<EnvironmentUnloadedListener>>();
    private final Map<String, Collection<IUpdateable>> updatables = new ConcurrentHashMap<String, Collection<IUpdateable>>();
    private final Map<String, Environment> environments = new ConcurrentHashMap<String, Environment>();
    private Environment environment;
    private ICamera camera;
    private int gravity;

    public GameWorld() {
        if (Game.world() != null) {
            throw new UnsupportedOperationException("Never initialize a GameWorld manually. Use Game.world() instead.");
        }
    }

    @Override
    public void update() {
        if (this.environment() == null) {
            return;
        }
        String mapName = GameWorld.getMapName(this.environment());
        if (mapName != null && this.updatables.containsKey(mapName)) {
            for (IUpdateable updatable : this.updatables.get(mapName)) {
                updatable.update();
            }
        }
    }

    public void addListener(EnvironmentListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(EnvironmentListener listener) {
        this.listeners.remove(listener);
    }

    public void onLoaded(EnvironmentLoadedListener listener) {
        this.loadedListeners.add(listener);
    }

    public void removeLoadedListener(EnvironmentLoadedListener listener) {
        this.loadedListeners.remove(listener);
    }

    public void onUnloaded(EnvironmentUnloadedListener listener) {
        this.unloadedListeners.add(listener);
    }

    public void removeUnloadedListener(EnvironmentUnloadedListener listener) {
        this.unloadedListeners.remove(listener);
    }

    public void onLoaded(String mapName, EnvironmentLoadedListener listener) {
        GameWorld.add(this.environmentLoadedListeners, mapName, listener);
    }

    public void removeLoadedListener(String mapName, EnvironmentLoadedListener listener) {
        GameWorld.remove(this.environmentLoadedListeners, mapName, listener);
    }

    public void onUnloaded(String mapName, EnvironmentUnloadedListener listener) {
        GameWorld.add(this.environmentUnloadedListeners, mapName, listener);
    }

    public void removeUnloadedListener(String mapName, EnvironmentUnloadedListener listener) {
        GameWorld.add(this.environmentUnloadedListeners, mapName, listener);
    }

    public void addListener(String mapName, EnvironmentListener listener) {
        GameWorld.add(this.environmentListeners, mapName, listener);
    }

    public void removeListener(String mapName, EnvironmentListener listener) {
        GameWorld.remove(this.environmentListeners, mapName, listener);
    }

    public void attach(String mapName, IUpdateable updateable) {
        GameWorld.add(this.updatables, mapName, updateable);
    }

    public void detach(String mapName, IUpdateable updateable) {
        GameWorld.remove(this.updatables, mapName, updateable);
    }

    public ICamera camera() {
        return this.camera;
    }

    public Environment environment() {
        return this.environment;
    }

    public int gravity() {
        return this.gravity;
    }

    public void clear() {
        this.unloadEnvironment();
        this.environments.clear();
        this.setCamera(null);
        Game.physics().clear();
        this.environmentListeners.clear();
        this.environmentLoadedListeners.clear();
        this.environmentUnloadedListeners.clear();
        this.listeners.clear();
        this.loadedListeners.clear();
        this.unloadedListeners.clear();
    }

    public Collection<Environment> getEnvironments() {
        return this.environments.values();
    }

    public Environment getEnvironment(String mapName) {
        if (mapName == null || mapName.isEmpty()) {
            return null;
        }
        IMap map = (IMap)Resources.maps().get(mapName);
        return this.getEnvironment(map);
    }

    public Environment getEnvironment(IMap map) {
        if (map == null || map.getName() == null || map.getName().isEmpty()) {
            return null;
        }
        Environment env = this.getEnvironments().stream().filter(e -> e.getMap().equals(map)).findFirst().orElse(null);
        if (env != null) {
            return env;
        }
        env = new Environment(map);
        this.addEnvironment(env);
        return env;
    }

    public boolean containsEnvironment(String mapName) {
        return this.environments.containsKey(mapName.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEnvironment(Environment env) {
        Lock lock = Game.loop().getLock();
        lock.lock();
        try {
            this.unloadEnvironment();
            this.environment = env;
            if (env != null) {
                this.addEnvironment(env);
                if (env.getGravity() == 0 && this.gravity() != 0) {
                    env.setGravity(this.gravity());
                }
                env.load();
                for (EnvironmentLoadedListener listener : this.loadedListeners) {
                    listener.loaded(env);
                }
                String mapName = GameWorld.getMapName(env);
                if (mapName != null && this.environmentLoadedListeners.containsKey(mapName)) {
                    if (this.camera().getClass().equals(Camera.class)) {
                        this.camera().setFocus(env.getCenter());
                    }
                    for (EnvironmentLoadedListener listener : this.environmentLoadedListeners.get(mapName)) {
                        listener.loaded(env);
                    }
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    public Environment loadEnvironment(String mapName) {
        Environment env = this.getEnvironment(mapName);
        this.loadEnvironment(env);
        return env;
    }

    public Environment loadEnvironment(IMap map) {
        Environment env = this.getEnvironment(map);
        this.loadEnvironment(env);
        return env;
    }

    public void unloadEnvironment() {
        if (this.environment() != null) {
            this.environment().unload();
            for (EnvironmentUnloadedListener listener : this.unloadedListeners) {
                listener.unloaded(this.environment());
            }
            String mapName = GameWorld.getMapName(this.environment());
            if (mapName != null && this.environmentUnloadedListeners.containsKey(mapName)) {
                for (EnvironmentUnloadedListener listener : this.environmentUnloadedListeners.get(mapName)) {
                    listener.unloaded(this.environment());
                }
            }
        }
        this.environment = null;
    }

    public Environment reset(String mapName) {
        if (mapName == null || mapName.isEmpty()) {
            return null;
        }
        return this.reset((IMap)Resources.maps().get(mapName));
    }

    public Environment reset(IMap map) {
        String mapName;
        if (map == null) {
            return null;
        }
        Environment env = this.getEnvironment(map);
        if (env != null && (mapName = GameWorld.getMapName(env)) != null) {
            this.environments.remove(mapName);
            if (this.environmentListeners.containsKey(mapName)) {
                for (EnvironmentListener listener : this.environmentListeners.get(mapName)) {
                    env.removeListener(listener);
                }
            }
            for (EnvironmentListener listener : this.listeners) {
                env.removeListener(listener);
            }
        }
        return env;
    }

    public void setCamera(ICamera cam) {
        if (this.camera() != null) {
            Game.loop().detach(this.camera);
        }
        this.camera = cam;
        if (cam != null && !Game.isInNoGUIMode()) {
            Game.loop().attach(cam);
            cam.updateFocus();
        }
    }

    public void setGravity(int gravity) {
        this.gravity = gravity;
    }

    private static <T> void add(Map<String, Collection<T>> listeners, String mapName, T listener) {
        if (mapName == null || mapName.isEmpty()) {
            return;
        }
        String mapIdentifier = mapName.toLowerCase();
        if (!listeners.containsKey(mapIdentifier)) {
            listeners.put(mapIdentifier, Collections.synchronizedCollection(ConcurrentHashMap.newKeySet()));
        }
        listeners.get(mapIdentifier).add(listener);
    }

    private static <T> void remove(Map<String, Collection<T>> listeners, String mapName, T listener) {
        if (mapName == null || mapName.isEmpty()) {
            return;
        }
        String mapIdentifier = mapName.toLowerCase();
        if (!listeners.containsKey(mapIdentifier)) {
            return;
        }
        listeners.get(mapIdentifier).remove(listener);
    }

    private static String getMapName(Environment env) {
        if (env.getMap() != null && env.getMap().getName() != null) {
            return env.getMap().getName().toLowerCase();
        }
        return null;
    }

    private void addEnvironment(Environment env) {
        String mapName = GameWorld.getMapName(env);
        if (mapName == null) {
            return;
        }
        if (this.containsEnvironment(mapName)) {
            return;
        }
        this.environments.put(mapName, env);
        if (this.environmentListeners.containsKey(mapName)) {
            for (EnvironmentListener listener : this.environmentListeners.get(mapName)) {
                env.addListener(listener);
            }
        }
        for (EnvironmentListener listener : this.listeners) {
            env.addListener(listener);
        }
    }
}

