/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.Spawnpoint;
import de.gurkenlabs.litiengine.environment.IEntitySpawner;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public abstract class EntitySpawner<T extends IEntity>
implements IEntitySpawner<T> {
    private int amount;
    private int interval;
    private long lastSpawnWave;
    private int spawnDelay;
    private IEntitySpawner.SpawnMode spawnMode;
    private List<Spawnpoint> spawnpoints;
    private Function<IEntitySpawner<T>, List<Spawnpoint>> customSpawnpoints;

    public EntitySpawner(int interval, int amount) {
        this.spawnDelay = 1000;
        this.interval = interval;
        this.amount = amount;
        this.spawnMode = IEntitySpawner.SpawnMode.CUSTOMSPAWNPOINTS;
    }

    public EntitySpawner(List<Spawnpoint> spawnpoints, int interval, int amount) {
        this(spawnpoints, interval, amount, IEntitySpawner.SpawnMode.ALLSPAWNPOINTS);
    }

    public EntitySpawner(List<Spawnpoint> spawnpoints, int amount, IEntitySpawner.SpawnMode spawnMode) {
        this.spawnDelay = 1000;
        this.amount = amount;
        this.spawnpoints = spawnpoints;
        this.spawnMode = spawnMode;
    }

    public EntitySpawner(List<Spawnpoint> spawnpoints, int interval, int amount, IEntitySpawner.SpawnMode spawnMode) {
        this.interval = interval;
        this.spawnDelay = 1000;
        this.amount = amount;
        this.spawnpoints = spawnpoints;
        this.spawnMode = spawnMode;
    }

    public EntitySpawner(int amount, Function<IEntitySpawner<T>, List<Spawnpoint>> spawnpointCallback) {
        Objects.nonNull(spawnpointCallback);
        this.amount = amount;
        this.customSpawnpoints = spawnpointCallback;
        this.spawnMode = IEntitySpawner.SpawnMode.CUSTOMSPAWNPOINTS;
    }

    public EntitySpawner(int interval, int amount, Function<IEntitySpawner<T>, List<Spawnpoint>> spawnpointCallback) {
        this(new ArrayList<Spawnpoint>(), interval, amount);
        Objects.nonNull(spawnpointCallback);
        this.customSpawnpoints = spawnpointCallback;
        this.spawnMode = IEntitySpawner.SpawnMode.CUSTOMSPAWNPOINTS;
    }

    @Override
    public int getSpawnAmount() {
        return this.amount;
    }

    @Override
    public int getSpawnInterval() {
        return this.interval;
    }

    @Override
    public int getSpawnDelay() {
        return this.spawnDelay;
    }

    @Override
    public IEntitySpawner.SpawnMode getSpawnMode() {
        return this.spawnMode;
    }

    @Override
    public List<Spawnpoint> getSpawnPoints() {
        return this.spawnpoints;
    }

    @Override
    public void setSpawnAmount(int amount) {
        this.amount = amount;
    }

    @Override
    public void setSpawnInterval(int interval) {
        this.interval = interval;
    }

    @Override
    public void setSpawnDelay(int delay) {
        this.spawnDelay = delay;
    }

    @Override
    public void setSpawnMode(IEntitySpawner.SpawnMode mode) {
        this.spawnMode = mode;
    }

    @Override
    public void update() {
        if (!this.shouldSpawn()) {
            return;
        }
        this.spawnNewEntities();
        this.lastSpawnWave = Game.time().now();
    }

    protected boolean shouldSpawn() {
        return this.lastSpawnWave == 0L || Game.time().since(this.lastSpawnWave) >= (long)this.getSpawnInterval();
    }

    protected List<Spawnpoint> getCustomSpawnpoints() {
        return new ArrayList<Spawnpoint>();
    }

    protected void spawnNewEntities() {
        if (this.getSpawnMode() != IEntitySpawner.SpawnMode.CUSTOMSPAWNPOINTS && this.getSpawnPoints().isEmpty()) {
            return;
        }
        switch (this.getSpawnMode()) {
            case ALLSPAWNPOINTS: {
                for (int i = 0; i < this.getSpawnPoints().size(); ++i) {
                    int index = i;
                    Game.loop().perform(this.getSpawnDelay() + this.getSpawnDelay() * i, () -> this.spawn(this.getSpawnPoints().get(index), this.getSpawnAmount()));
                }
                break;
            }
            case ONERANDOMSPAWNPOINT: {
                this.spawn(Game.random().choose(this.getSpawnPoints()), this.getSpawnAmount());
                break;
            }
            case RANDOMSPAWNPOINTS: {
                for (int i = 0; i < this.getSpawnAmount(); ++i) {
                    Game.loop().perform(this.getSpawnDelay() + this.getSpawnDelay() * i, () -> this.spawn(Game.random().choose(this.getSpawnPoints()), 1));
                }
                break;
            }
            case CUSTOMSPAWNPOINTS: {
                List<Spawnpoint> spawnPoints = this.customSpawnpoints != null ? this.customSpawnpoints.apply(this) : this.getCustomSpawnpoints();
                int index = 0;
                for (Spawnpoint spawn : spawnPoints) {
                    Game.loop().perform(this.getSpawnDelay() + this.getSpawnDelay() * index, () -> this.spawn(spawn, 1));
                    ++index;
                }
                break;
            }
        }
    }

    private void spawn(Spawnpoint spawnpoint, int amount) {
        if (spawnpoint.getEnvironment() == null || !spawnpoint.getEnvironment().isLoaded()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            Object newEntity = this.createNew();
            spawnpoint.spawn((IEntity)newEntity);
        }
    }
}

