/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.configuration;

import de.gurkenlabs.litiengine.configuration.ConfigurationGroup;
import de.gurkenlabs.litiengine.configuration.ConfigurationGroupInfo;
import de.gurkenlabs.litiengine.configuration.DisplayMode;
import de.gurkenlabs.litiengine.configuration.Quality;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;

@ConfigurationGroupInfo(prefix="gfx_")
public class GraphicConfiguration
extends ConfigurationGroup {
    private DisplayMode displayMode;
    private Quality graphicQuality = Quality.LOW;
    private boolean renderDynamicShadows = false;
    private int resolutionHeight;
    private int resolutionWidth;
    private boolean enableResolutionScale;
    private boolean reduceFramesWhenNotFocused;
    private boolean antiAliasing;
    private boolean colorInterpolation;

    GraphicConfiguration() {
        this.displayMode = DisplayMode.WINDOWED;
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.resolutionWidth = d.width;
        this.resolutionHeight = d.height - 100;
        this.setEnableResolutionScale(true);
        this.setReduceFramesWhenNotFocused(true);
        this.setAntiAliasing(false);
        this.setColorInterpolation(false);
    }

    public Quality getGraphicQuality() {
        return this.graphicQuality;
    }

    public Dimension getResolution() {
        if (this.getDisplayMode() == DisplayMode.FULLSCREEN) {
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            int width = gd.getDisplayMode().getWidth();
            int height = gd.getDisplayMode().getHeight();
            return new Dimension(width, height);
        }
        return new Dimension(this.resolutionWidth, this.resolutionHeight);
    }

    public int getResolutionHeight() {
        return this.resolutionHeight;
    }

    public int getResolutionWidth() {
        return this.resolutionWidth;
    }

    public boolean renderDynamicShadows() {
        return this.renderDynamicShadows;
    }

    public boolean antiAlising() {
        return this.antiAliasing;
    }

    public boolean colorInterpolation() {
        return this.colorInterpolation;
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.set("displayMode", displayMode);
    }

    public void setGraphicQuality(Quality graphicQuality) {
        this.set("graphicQuality", graphicQuality);
    }

    public void setRenderDynamicShadows(boolean renderDynamicShadows) {
        this.set("renderDynamicShadows", renderDynamicShadows);
    }

    public void setResolutionHeight(int resolutionHeight) {
        this.set("resolutionHeight", resolutionHeight);
    }

    public void setResolutionWidth(int resolutionWidth) {
        this.set("resolutionWidth", resolutionWidth);
    }

    public boolean enableResolutionScaling() {
        return this.enableResolutionScale;
    }

    public void setEnableResolutionScale(boolean enableResolutionScale) {
        this.set("enableResolutionScale", enableResolutionScale);
    }

    public boolean reduceFramesWhenNotFocused() {
        return this.reduceFramesWhenNotFocused;
    }

    public void setReduceFramesWhenNotFocused(boolean reduceFramesWhenNotFocused) {
        this.set("reduceFramesWhenNotFocused", reduceFramesWhenNotFocused);
    }

    public void setAntiAliasing(boolean antiAliasing) {
        this.set("antiAliasing", antiAliasing);
    }

    public void setColorInterpolation(boolean colorInterpolation) {
        this.set("colorInterpolation", colorInterpolation);
    }
}

