/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.attributes;

import de.gurkenlabs.litiengine.attributes.Attribute;
import de.gurkenlabs.litiengine.attributes.AttributeModifier;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class RangeAttribute<T extends Number>
extends Attribute<T> {
    private final List<AttributeModifier<T>> minModifiers = new CopyOnWriteArrayList<AttributeModifier<T>>();
    private final List<AttributeModifier<T>> maxModifiers = new CopyOnWriteArrayList<AttributeModifier<T>>();
    private T minBaseValue;
    private T maxBaseValue;

    public RangeAttribute(T maxValue, T minValue, T baseValue) {
        super(baseValue);
        this.maxBaseValue = maxValue;
        this.minBaseValue = minValue;
    }

    public void addMinModifier(AttributeModifier<T> modifier) {
        if (this.getMinModifiers().contains(modifier)) {
            return;
        }
        this.getMinModifiers().add(modifier);
        Collections.sort(this.getMinModifiers());
    }

    public void addMaxModifier(AttributeModifier<T> modifier) {
        if (this.getMaxModifiers().contains(modifier)) {
            return;
        }
        this.getMaxModifiers().add(modifier);
        Collections.sort(this.getMaxModifiers());
    }

    @Override
    public T get() {
        Object current = this.applyModifiers(this.getBase());
        return this.valueInRange(current);
    }

    public T getMin() {
        return this.applyMinModifiers(this.minBaseValue);
    }

    public T getMax() {
        return this.applyMaxModifiers(this.maxBaseValue);
    }

    public float getRelativeCurrentValue() {
        return ((Number)this.get()).floatValue() / ((Number)this.getMax()).floatValue();
    }

    @Override
    public void modifyBaseValue(AttributeModifier<T> modifier) {
        this.setBaseValue(this.valueInRange(modifier.modify(this.getBase())));
    }

    public void modifyMaxBaseValue(AttributeModifier<T> modifier) {
        this.maxBaseValue = modifier.modify(this.maxBaseValue);
    }

    public void setToMin() {
        this.setBaseValue(this.getMin());
    }

    public void setToMax() {
        this.setBaseValue(this.getMax());
    }

    public void setMaxBaseValue(T maxValue) {
        this.maxBaseValue = maxValue;
    }

    public void setMinBaseValue(T minValue) {
        this.minBaseValue = minValue;
    }

    protected List<AttributeModifier<T>> getMinModifiers() {
        return this.minModifiers;
    }

    protected List<AttributeModifier<T>> getMaxModifiers() {
        return this.maxModifiers;
    }

    protected T applyMinModifiers(T maxValue) {
        T currentValue = maxValue;
        for (AttributeModifier<T> modifier : this.getMinModifiers()) {
            currentValue = modifier.modify(currentValue);
        }
        return currentValue;
    }

    protected T applyMaxModifiers(T maxValue) {
        T currentValue = maxValue;
        for (AttributeModifier<T> modifier : this.getMaxModifiers()) {
            currentValue = modifier.modify(currentValue);
        }
        return currentValue;
    }

    private T valueInRange(T value) {
        if (((Number)value).doubleValue() < ((Number)this.minBaseValue).doubleValue()) {
            return this.minBaseValue;
        }
        if (((Number)value).doubleValue() > ((Number)this.getMax()).doubleValue()) {
            return this.getMax();
        }
        return value;
    }
}

