/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.attributes;

import de.gurkenlabs.litiengine.attributes.Modification;

public class AttributeModifier<T extends Number>
implements Comparable<AttributeModifier<T>> {
    private final Modification modification;
    private double modifyValue;
    private boolean active;

    public AttributeModifier(Modification mod, double modifyValue) {
        this.modification = mod;
        this.modifyValue = modifyValue;
        this.active = true;
    }

    @Override
    public int compareTo(AttributeModifier<T> otherModifier) {
        return Integer.compare(this.getModification().getApplyOrder(), otherModifier.getModification().getApplyOrder());
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttributeModifier) {
            AttributeModifier attr = (AttributeModifier)obj;
            return this.isActive() == attr.isActive() && this.getModification() == attr.getModification() && this.getModifyValue() == attr.getModifyValue();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Modification getModification() {
        return this.modification;
    }

    public double getModifyValue() {
        return this.modifyValue;
    }

    public boolean isActive() {
        return this.active;
    }

    public T modify(T modvalue) {
        if (!this.isActive()) {
            return modvalue;
        }
        switch (this.getModification()) {
            case ADD: {
                return this.ensureType(((Number)modvalue).doubleValue() + this.getModifyValue(), modvalue);
            }
            case SUBTRACT: {
                return this.ensureType(((Number)modvalue).doubleValue() - this.getModifyValue(), modvalue);
            }
            case MULTIPLY: {
                return this.ensureType(((Number)modvalue).doubleValue() * this.getModifyValue(), modvalue);
            }
            case DIVIDE: {
                return this.ensureType(((Number)modvalue).doubleValue() / this.getModifyValue(), modvalue);
            }
            case ADDPERCENT: {
                return this.ensureType(((Number)modvalue).doubleValue() + ((Number)modvalue).doubleValue() / 100.0 * this.getModifyValue(), modvalue);
            }
            case SUBTRACTPERCENT: {
                return this.ensureType(((Number)modvalue).doubleValue() - ((Number)modvalue).doubleValue() / 100.0 * this.getModifyValue(), modvalue);
            }
            case SET: {
                return this.ensureType(this.getModifyValue(), modvalue);
            }
        }
        return modvalue;
    }

    public void setModifyValue(double value) {
        this.modifyValue = value;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    private T ensureType(Double modValue, T originalValue) {
        if (originalValue instanceof Double) {
            return (T)modValue;
        }
        if (originalValue instanceof Float) {
            return (T)Float.valueOf(modValue.floatValue());
        }
        if (originalValue instanceof Long) {
            return (T)Long.valueOf(modValue.longValue());
        }
        if (originalValue instanceof Byte) {
            return (T)Byte.valueOf(modValue.byteValue());
        }
        if (originalValue instanceof Short) {
            return (T)Short.valueOf(modValue.shortValue());
        }
        if (originalValue instanceof Integer) {
            return (T)Integer.valueOf(modValue.intValue());
        }
        return null;
    }
}

