/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.abilities.effects;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.abilities.Ability;
import de.gurkenlabs.litiengine.abilities.effects.EffectApplication;
import de.gurkenlabs.litiengine.abilities.effects.EffectEvent;
import de.gurkenlabs.litiengine.abilities.effects.EffectTarget;
import de.gurkenlabs.litiengine.entities.EntityDistanceComparator;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import de.gurkenlabs.litiengine.entities.RelativeEntityComparator;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public abstract class Effect
implements IUpdateable {
    private final Ability ability;
    private final List<EffectApplication> appliances;
    private final Collection<EffectAppliedListener> appliedListeners = ConcurrentHashMap.newKeySet();
    private final Collection<EffectCeasedListener> ceasedListeners = ConcurrentHashMap.newKeySet();
    private final EffectTarget[] effectTargets;
    private final List<Effect> followUpEffects;
    private int delay;
    private int duration;
    private RelativeEntityComparator targetPriorityComparator;

    protected Effect(Ability ability, EffectTarget ... targets) {
        this.appliances = new ArrayList<EffectApplication>();
        this.followUpEffects = new CopyOnWriteArrayList<Effect>();
        this.ability = ability;
        this.targetPriorityComparator = new EntityDistanceComparator(this.getAbility().getExecutor());
        this.duration = ability.getAttributes().duration().get();
        this.effectTargets = targets == null || targets.length == 0 ? new EffectTarget[]{EffectTarget.NONE} : targets;
    }

    public void onEffectApplied(EffectAppliedListener listener) {
        this.appliedListeners.add(listener);
    }

    public void removeEffectAppliedListener(EffectAppliedListener listener) {
        this.appliedListeners.remove(listener);
    }

    public void onEffectCeased(EffectCeasedListener listener) {
        this.ceasedListeners.add(listener);
    }

    public void removeEffectCeasedListener(EffectCeasedListener listener) {
        this.ceasedListeners.remove(listener);
    }

    public void apply(Shape impactArea) {
        List<ICombatEntity> affected = this.lookForAffectedEntities(impactArea);
        for (ICombatEntity affectedEntity : affected) {
            this.apply(affectedEntity);
        }
        this.appliances.add(new EffectApplication(affected, impactArea));
        if (this.appliances.size() == 1) {
            Game.loop().attach(this);
        }
    }

    public void cease(ICombatEntity entity) {
        entity.getAppliedEffects().remove(this);
        EffectEvent event = new EffectEvent(this, entity);
        for (EffectCeasedListener listener : this.ceasedListeners) {
            listener.ceased(event);
        }
    }

    public Ability getAbility() {
        return this.ability;
    }

    public List<EffectApplication> getActiveAppliances() {
        return this.appliances;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getDuration() {
        return this.duration;
    }

    public EffectTarget[] getEffectTargets() {
        return this.effectTargets;
    }

    public List<Effect> getFollowUpEffects() {
        return this.followUpEffects;
    }

    public RelativeEntityComparator getTargetPriorityComparator() {
        return this.targetPriorityComparator;
    }

    public boolean isActive(ICombatEntity entity) {
        return this.getActiveAppliances().stream().anyMatch(a -> a.getAffectedEntities().stream().anyMatch(e -> e.equals(entity)));
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setTargetPriorityComparator(RelativeEntityComparator targetPriorityComparator) {
        this.targetPriorityComparator = targetPriorityComparator;
    }

    @Override
    public void update() {
        Iterator<EffectApplication> iterator = this.getActiveAppliances().iterator();
        while (iterator.hasNext()) {
            EffectApplication appliance = iterator.next();
            if (!this.hasEnded(appliance)) continue;
            iterator.remove();
            this.cease(appliance);
        }
        if (this.getActiveAppliances().isEmpty()) {
            Game.loop().detach(this);
        }
    }

    protected void apply(ICombatEntity entity) {
        entity.getAppliedEffects().add(this);
        EffectEvent event = new EffectEvent(this, entity);
        for (EffectAppliedListener listener : this.appliedListeners) {
            listener.applied(event);
        }
    }

    protected void cease(EffectApplication appliance) {
        for (ICombatEntity entity : appliance.getAffectedEntities()) {
            this.cease(entity);
        }
        this.getFollowUpEffects().forEach(followUp -> followUp.apply(appliance.getImpactArea()));
    }

    protected Collection<ICombatEntity> getEntitiesInImpactArea(Shape impactArea) {
        return Game.world().environment().findCombatEntities(impactArea);
    }

    protected long getTotalDuration() {
        return (long)this.getDuration() + (long)this.getDelay();
    }

    protected boolean hasEnded(EffectApplication appliance) {
        long effectDuration = Game.time().since(appliance.getAppliedTicks());
        return effectDuration > (long)this.getDuration();
    }

    protected List<ICombatEntity> lookForAffectedEntities(Shape impactArea) {
        List<ICombatEntity> affectedEntities = new ArrayList<ICombatEntity>();
        block8: for (EffectTarget target : this.effectTargets) {
            switch (target) {
                case EXECUTINGENTITY: {
                    affectedEntities.add(this.getAbility().getExecutor());
                    return affectedEntities;
                }
                case ENEMY: {
                    affectedEntities.addAll(this.getEntitiesInImpactArea(impactArea));
                    affectedEntities = affectedEntities.stream().filter(this::canAffectEntity).collect(Collectors.toList());
                    continue block8;
                }
                case FRIENDLY: {
                    affectedEntities.addAll(this.getEntitiesInImpactArea(impactArea));
                    affectedEntities = affectedEntities.stream().filter(this::isAliveFriendlyEntity).collect(Collectors.toList());
                    continue block8;
                }
                case FRIENDLYDEAD: {
                    affectedEntities.addAll(this.getEntitiesInImpactArea(impactArea));
                    affectedEntities = affectedEntities.stream().filter(this::isDeadFriendlyEntity).collect(Collectors.toList());
                    continue block8;
                }
                case CUSTOM: {
                    affectedEntities.addAll(this.getEntitiesInImpactArea(impactArea));
                    affectedEntities = affectedEntities.stream().filter(this::customTarget).collect(Collectors.toList());
                    continue block8;
                }
                case NONE: {
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)target));
                }
            }
        }
        affectedEntities.removeAll(Collections.singleton(null));
        affectedEntities.sort(this.targetPriorityComparator);
        if (!this.getAbility().isMultiTarget() && !affectedEntities.isEmpty()) {
            ICombatEntity target = this.getAbility().getExecutor().getTarget() != null ? this.getAbility().getExecutor().getTarget() : (ICombatEntity)affectedEntities.get(0);
            affectedEntities = new ArrayList();
            affectedEntities.add(target);
        }
        return affectedEntities;
    }

    protected boolean customTarget(ICombatEntity entity) {
        return entity != null;
    }

    protected boolean canAffectEntity(ICombatEntity entity) {
        return !entity.equals(this.getAbility().getExecutor()) && !entity.isFriendly(this.getAbility().getExecutor()) && !entity.isDead();
    }

    protected boolean isAliveFriendlyEntity(ICombatEntity entity) {
        return !entity.equals(this.getAbility().getExecutor()) && entity.isFriendly(this.getAbility().getExecutor()) && !entity.isDead();
    }

    protected boolean isDeadFriendlyEntity(ICombatEntity entity) {
        return !entity.equals(this.getAbility().getExecutor()) && entity.isFriendly(this.getAbility().getExecutor()) && entity.isDead();
    }

    @FunctionalInterface
    public static interface EffectCeasedListener
    extends EventListener {
        public void ceased(EffectEvent var1);
    }

    @FunctionalInterface
    public static interface EffectAppliedListener
    extends EventListener {
        public void applied(EffectEvent var1);
    }
}

