/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.ILoop;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.util.TimeUtilities;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdateLoop
extends Thread
implements AutoCloseable,
ILoop {
    private static final Logger log = Logger.getLogger(UpdateLoop.class.getName());
    private final Set<IUpdateable> updatables = ConcurrentHashMap.newKeySet();
    private final Lock lock = new ReentrantLock();
    private int tickRate;
    private long totalTicks;
    private long deltaTime;
    private double processTime;
    private double delayError;

    protected UpdateLoop(String name, int tickRate) {
        super(name);
        this.tickRate = tickRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!UpdateLoop.interrupted()) {
            double delay;
            ++this.totalTicks;
            long start = System.nanoTime();
            Lock theLock = this.getLock();
            theLock.lock();
            try {
                this.process();
            }
            finally {
                theLock.unlock();
            }
            this.processTime = TimeUtilities.nanoToMs(System.nanoTime() - start);
            try {
                delay = this.delay();
            }
            catch (InterruptedException e) {
                break;
            }
            this.deltaTime = (long)(delay + this.processTime);
        }
    }

    @Override
    public void terminate() {
        this.interrupt();
    }

    @Override
    public void close() {
        this.terminate();
    }

    @Override
    public void attach(IUpdateable updatable) {
        if (updatable == null) {
            return;
        }
        if (!this.updatables.add(updatable)) {
            log.log(Level.FINE, "Updatable {0} already registered for update!", new Object[]{updatable});
        }
    }

    @Override
    public void detach(IUpdateable updatable) {
        this.updatables.remove(updatable);
    }

    @Override
    public int getUpdatableCount() {
        return this.updatables.size();
    }

    @Override
    public long getTicks() {
        return this.totalTicks;
    }

    @Override
    public int getTickRate() {
        return this.tickRate;
    }

    @Override
    public long getDeltaTime() {
        return this.deltaTime;
    }

    @Override
    public double getProcessTime() {
        return this.processTime;
    }

    @Override
    public void setTickRate(int tickRate) {
        this.tickRate = tickRate;
    }

    protected Set<IUpdateable> getUpdatables() {
        return this.updatables;
    }

    protected void process() {
        this.update();
    }

    protected long getExpectedDelta() {
        return (long)(1000.0 / (double)this.tickRate);
    }

    protected void update() {
        for (IUpdateable updatable : this.getUpdatables()) {
            try {
                if (updatable == null) continue;
                updatable.update();
            }
            catch (Exception e) {
                if (Game.config().client().exitOnError()) {
                    throw e;
                }
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected double delay() throws InterruptedException {
        double delay = Math.max(0.0, (double)this.getExpectedDelta() - this.getProcessTime());
        long sleepDelay = Math.round(delay);
        this.delayError += delay - (double)sleepDelay;
        if (Math.abs(this.delayError) > 1.0) {
            long errorAdjustment = (long)this.delayError;
            sleepDelay += errorAdjustment;
            this.delayError -= (double)errorAdjustment;
        }
        if (delay > 0.0) {
            UpdateLoop.sleep(sleepDelay);
        }
        return delay;
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }
}

