/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.util.MathUtilities;
import jakarta.xml.bind.annotation.XmlEnum;

@XmlEnum
public enum Align {
    CENTER(0.5f),
    LEFT(0.0f),
    RIGHT(1.0f),
    CENTER_LEFT(0.25f),
    CENTER_RIGHT(0.75f);

    private final float portion;

    private Align(float portion) {
        this.portion = portion;
    }

    public static Align get(String alignString) {
        if (alignString == null || alignString.isEmpty()) {
            return CENTER;
        }
        try {
            return Align.valueOf(alignString.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            return CENTER;
        }
    }

    public float getValue(float width) {
        return width * this.portion;
    }

    public double getValue(double width) {
        return width * (double)this.portion;
    }

    public int getValue(int width) {
        return (int)((float)width * this.portion);
    }

    public double getLocation(double width, double objectWidth) {
        double value = this.getValue(width);
        double location = value - objectWidth / 2.0;
        if (objectWidth > width) {
            return location;
        }
        return MathUtilities.clamp(location, 0.0, width - objectWidth);
    }
}

