/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util.io;

import de.gurkenlabs.litiengine.resources.ImageFormat;
import de.gurkenlabs.litiengine.util.Imaging;
import de.gurkenlabs.litiengine.util.io.FileUtilities;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;

public final class ImageSerializer {
    private static final Logger log = Logger.getLogger(ImageSerializer.class.getName());

    private ImageSerializer() {
        throw new UnsupportedOperationException();
    }

    public static BufferedImage loadImage(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return null;
        }
        try {
            BufferedImage img = ImageIO.read(file);
            if (img == null) {
                return null;
            }
            BufferedImage compatibleImg = Imaging.getCompatibleImage(img.getWidth(), img.getHeight());
            compatibleImg.createGraphics().drawImage((Image)img, 0, 0, null);
            compatibleImg.createGraphics().dispose();
            return compatibleImg;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static void saveImage(String fileName, BufferedImage image) {
        ImageSerializer.saveImage(fileName, image, ImageFormat.PNG);
    }

    public static void saveImage(String fileName, BufferedImage image, ImageFormat imageFormat) {
        try {
            File file = new File(fileName);
            String extension = FileUtilities.getExtension(fileName);
            Iterator<ImageWriter> iter = null;
            iter = ImageSerializer.canWriteFormat(extension) ? ImageIO.getImageWritersByFormatName(extension) : ImageIO.getImageWritersByFormatName(imageFormat.toString());
            ImageWriter writer = iter.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            file.getParentFile().mkdirs();
            try (FileImageOutputStream output = new FileImageOutputStream(file.getAbsoluteFile());){
                writer.setOutput(output);
                IIOImage outimage = new IIOImage(image, null, null);
                writer.write(null, outimage, iwp);
                writer.dispose();
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private static boolean canWriteFormat(String formatName) {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
        return iter.hasNext();
    }
}

