/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.sound;

import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.sound.Sound;
import de.gurkenlabs.litiengine.sound.Track;
import java.util.Iterator;
import java.util.Objects;
import javax.sound.sampled.AudioFormat;

public class LoopedTrack
implements Track,
Iterator<Sound> {
    private Sound track;

    public LoopedTrack(String soundName) {
        this((Sound)Resources.sounds().get(soundName));
    }

    public LoopedTrack(Sound sound) {
        this.track = Objects.requireNonNull(sound);
    }

    @Override
    public Iterator<Sound> iterator() {
        return this;
    }

    @Override
    public AudioFormat getFormat() {
        return this.track.getFormat();
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public Sound next() {
        return this.track;
    }

    public boolean equals(Object anObject) {
        return this == anObject || anObject instanceof LoopedTrack && ((LoopedTrack)anObject).track.equals(this.track);
    }

    public int hashCode() {
        return this.track.hashCode();
    }

    public String toString() {
        return "looped track: " + String.valueOf(this.track);
    }
}

