/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.input;

import de.gurkenlabs.litiengine.input.GamepadEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class GamepadEvents {
    protected final Map<String, Collection<GamepadPollListener>> componentPollListeners = new ConcurrentHashMap<String, Collection<GamepadPollListener>>();
    protected final Map<String, Collection<GamepadPressedListener>> componentPressedListeners = new ConcurrentHashMap<String, Collection<GamepadPressedListener>>();
    protected final Map<String, Collection<GamepadReleasedListener>> componentReleasedListeners = new ConcurrentHashMap<String, Collection<GamepadReleasedListener>>();
    protected final Collection<GamepadPollListener> pollListeners = ConcurrentHashMap.newKeySet();
    protected final Collection<GamepadPressedListener> pressedListeners = ConcurrentHashMap.newKeySet();
    protected final Collection<GamepadReleasedListener> releasedListeners = ConcurrentHashMap.newKeySet();

    protected GamepadEvents() {
    }

    public void onPoll(String identifier, GamepadPollListener listener) {
        GamepadEvents.addComponentListener(this.componentPollListeners, identifier, listener);
    }

    public void removePollListener(String identifier, GamepadPollListener listener) {
        GamepadEvents.removeComponentListener(this.componentPollListeners, identifier, listener);
    }

    public void onPressed(String identifier, GamepadPressedListener listener) {
        GamepadEvents.addComponentListener(this.componentPressedListeners, identifier, listener);
    }

    public void removePressedListener(String identifier, GamepadPressedListener listener) {
        GamepadEvents.removeComponentListener(this.componentPressedListeners, identifier, listener);
    }

    public void onReleased(String identifier, GamepadReleasedListener listener) {
        GamepadEvents.addComponentListener(this.componentReleasedListeners, identifier, listener);
    }

    public void removeReleasedListener(String identifier, GamepadReleasedListener listener) {
        GamepadEvents.removeComponentListener(this.componentReleasedListeners, identifier, listener);
    }

    public void onPoll(GamepadPollListener listener) {
        this.pollListeners.add(listener);
    }

    public void removePollListener(GamepadPollListener listener) {
        this.pollListeners.remove(listener);
    }

    public void onPressed(GamepadPressedListener listener) {
        this.pressedListeners.add(listener);
    }

    public void removePressedListener(GamepadPressedListener listener) {
        this.pressedListeners.remove(listener);
    }

    public void onReleased(GamepadReleasedListener listener) {
        this.releasedListeners.add(listener);
    }

    public void removeReleasedListener(GamepadReleasedListener listener) {
        this.releasedListeners.remove(listener);
    }

    public void clearEventListeners() {
        this.componentPollListeners.clear();
        this.componentPressedListeners.clear();
        this.componentReleasedListeners.clear();
        this.pollListeners.clear();
        this.pressedListeners.clear();
        this.releasedListeners.clear();
    }

    public abstract boolean isPressed(String var1);

    private static <T> void addComponentListener(Map<String, Collection<T>> consumerList, String identifier, T consumer) {
        if (!consumerList.containsKey(identifier)) {
            consumerList.put(identifier, new ArrayList());
        }
        consumerList.get(identifier).add(consumer);
    }

    private static <T> void removeComponentListener(Map<String, Collection<T>> consumerList, String identifier, T consumer) {
        if (!consumerList.containsKey(identifier)) {
            return;
        }
        consumerList.get(identifier).remove(consumer);
    }

    @FunctionalInterface
    public static interface GamepadReleasedListener
    extends EventListener {
        public void released(GamepadEvent var1);
    }

    @FunctionalInterface
    public static interface GamepadPressedListener
    extends EventListener {
        public void pressed(GamepadEvent var1);
    }

    @FunctionalInterface
    public static interface GamepadPollListener
    extends EventListener {
        public void polled(GamepadEvent var1);
    }
}

