/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.input;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.input.Gamepad;
import de.gurkenlabs.litiengine.input.Input;
import de.gurkenlabs.litiengine.physics.MovementController;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.geom.Point2D;

public class GamepadEntityController<T extends IMobileEntity>
extends MovementController<T> {
    private int gamepadId = -1;
    private double gamepadDeadzone = Game.config().input().getGamepadStickDeadzone();
    private double gamepadRightStick = Game.config().input().getGamepadStickDeadzone();
    private boolean rotateWithRightStick = false;

    public GamepadEntityController(T entity, boolean rotateWithRightStick) {
        super(entity);
        if (Input.gamepads().current() != null) {
            this.gamepadId = Input.gamepads().current().getId();
        }
        this.rotateWithRightStick = rotateWithRightStick;
        Input.gamepads().onAdded(pad -> {
            if (this.gamepadId == -1) {
                this.gamepadId = pad.getId();
            }
        });
        Input.gamepads().onRemoved(pad -> {
            if (this.gamepadId == pad.getId()) {
                this.gamepadId = -1;
                Gamepad newGamePad = Input.gamepads().current();
                if (newGamePad != null) {
                    this.gamepadId = newGamePad.getId();
                }
            }
        });
    }

    @Override
    public void update() {
        this.retrieveGamepadValues();
        super.update();
    }

    public double getGamepadDeadzone() {
        return this.gamepadDeadzone;
    }

    public double getGamepadRightStick() {
        return this.gamepadRightStick;
    }

    public boolean isRotateWithRightStick() {
        return this.rotateWithRightStick;
    }

    public void setRightStickDeadzone(double gamePadRightStick) {
        this.gamepadRightStick = gamePadRightStick;
    }

    public void setLeftStickDeadzone(double gamePadDeadzone) {
        this.gamepadDeadzone = gamePadDeadzone;
    }

    public void setRotateWithRightStick(boolean rotateWithRightStick) {
        this.rotateWithRightStick = rotateWithRightStick;
    }

    private void retrieveGamepadValues() {
        Gamepad gamepad = Input.gamepads().getById(this.gamepadId);
        if (this.gamepadId == -1 || this.gamepadId != -1 && gamepad == null) {
            return;
        }
        float x = gamepad.getPollData(Gamepad.Axis.X);
        float y = gamepad.getPollData(Gamepad.Axis.Y);
        if ((double)Math.abs(x) > this.gamepadDeadzone) {
            this.setDx(x);
        }
        if ((double)Math.abs(y) > this.gamepadDeadzone) {
            this.setDy(y);
        }
        if (this.isRotateWithRightStick()) {
            float rightX = gamepad.getPollData(Gamepad.Axis.RX);
            float rightY = gamepad.getPollData(Gamepad.Axis.RY);
            float targetX = 0.0f;
            float targetY = 0.0f;
            if ((double)Math.abs(rightX) > this.gamepadRightStick) {
                targetX = rightX;
            }
            if ((double)Math.abs(rightY) > this.gamepadRightStick) {
                targetY = rightY;
            }
            if (targetX != 0.0f || targetY != 0.0f) {
                Point2D.Double target = new Point2D.Double(this.getEntity().getCenter().getX() + (double)targetX, this.getEntity().getCenter().getY() + (double)targetY);
                double angle = GeometricUtilities.calcRotationAngleInDegrees(this.getEntity().getCenter(), target);
                this.getEntity().setAngle((float)angle);
            }
        }
    }
}

