/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Valign;
import de.gurkenlabs.litiengine.graphics.ImageRenderer;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.gui.GuiComponent;
import de.gurkenlabs.litiengine.gui.ImageScaleMode;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.util.Imaging;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Optional;
import javax.swing.JLabel;

public class ImageComponent
extends GuiComponent {
    public static final int BACKGROUND_INDEX = 0;
    public static final int BACKGROUND_HOVER_INDEX = 1;
    public static final int BACKGROUND_PRESSED_INDEX = 2;
    public static final int BACKGROUND_DISABLED_INDEX = 3;
    private BufferedImage baseImage;
    private BufferedImage scaledImage;
    private Spritesheet spritesheet;
    private ImageScaleMode imageScaleMode = ImageScaleMode.NORMAL;
    private ImageScaleMode spritesheetScaleMode = ImageScaleMode.NORMAL;
    private float spritesheetScaleFactor = 1.0f;
    private Align imageAlign = Align.CENTER;
    private Valign imageValign = Valign.MIDDLE;

    public ImageComponent(double x, double y, Image image) {
        super(x, y, image.getWidth(null), image.getHeight(null));
        this.baseImage = (BufferedImage)image;
    }

    public ImageComponent(double x, double y, double width, double height) {
        super(x, y, width, height);
    }

    public ImageComponent(double x, double y, double width, double height, String text) {
        super(x, y, width, height);
        Font defFont = new JLabel().getFont().deriveFont((float)(this.getHeight() * 3.0 / 6.0));
        if (this.getFont() == null) {
            this.setFont(defFont);
        }
        this.setText(text);
    }

    public ImageComponent(double x, double y, double width, double height, Image image) {
        super(x, y, width, height);
        this.setImage(image);
    }

    public ImageComponent(double x, double y, double width, double height, Spritesheet spritesheet, String text, Image image) {
        this(x, y, width, height, text);
        this.spritesheet = spritesheet;
        this.setImageAlign(Align.LEFT);
        this.setImageValign(Valign.TOP);
        if (image != null) {
            this.baseImage = (BufferedImage)image;
        }
    }

    public Image getBackground() {
        BufferedImage img;
        if (this.getSpritesheet() == null) {
            return null;
        }
        String cacheKey = this.getSpritesheet().getName().hashCode() + "_" + this.isHovered() + "_" + this.isPressed() + "_" + this.isEnabled() + "_" + this.getWidth() + "_" + this.getSpritesheetScaleMode().name().toLowerCase() + "x" + this.getHeight();
        Optional opt = Resources.images().tryGet(cacheKey);
        if (opt.isPresent()) {
            return (Image)opt.get();
        }
        if (this.getSpritesheetScaleMode() == ImageScaleMode.SLICE) {
            img = Imaging.nineSlice(this.getSpritesheet(), (int)this.getWidth(), (int)this.getHeight(), this.getSpritesheetScaleFactor());
        } else {
            int spriteIndex = 0;
            if (!this.isEnabled() && this.getSpritesheet().getTotalNumberOfSprites() > 3) {
                spriteIndex = 3;
            } else if (this.isPressed() && this.getSpritesheet().getTotalNumberOfSprites() > 2) {
                spriteIndex = 2;
            } else if (this.isHovered() && this.getSpritesheet().getTotalNumberOfSprites() > 1) {
                spriteIndex = 1;
            }
            img = Imaging.scale(this.getSpritesheet().getSprite(spriteIndex), (int)this.getWidth(), (int)this.getHeight());
        }
        if (img != null) {
            Resources.images().add(cacheKey, img);
        }
        return img;
    }

    public void rescaleImage() {
        boolean keepRatio;
        if (this.baseImage == null) {
            return;
        }
        int imageWidth = (int)this.getWidth();
        int imageHeight = (int)this.getHeight();
        switch (this.getImageScaleMode()) {
            case STRETCH: {
                keepRatio = false;
                break;
            }
            case FIT: {
                keepRatio = true;
                break;
            }
            default: {
                return;
            }
        }
        String cacheKey = String.format("%s_%dx%d_%b", this.baseImage.hashCode(), imageWidth, imageHeight, keepRatio);
        Optional opt = Resources.images().tryGet(cacheKey);
        if (opt.isPresent()) {
            this.scaledImage = (BufferedImage)opt.get();
            return;
        }
        this.scaledImage = Imaging.scale(this.baseImage, imageWidth, imageHeight, keepRatio);
        Resources.images().add(cacheKey, this.scaledImage);
    }

    public BufferedImage getImage() {
        if (this.scaledImage == null) {
            return this.baseImage;
        }
        return this.scaledImage;
    }

    public Align getImageAlign() {
        return this.imageAlign;
    }

    public ImageScaleMode getImageScaleMode() {
        return this.imageScaleMode;
    }

    public ImageScaleMode getSpritesheetScaleMode() {
        return this.spritesheetScaleMode;
    }

    public float getSpritesheetScaleFactor() {
        return this.spritesheetScaleFactor;
    }

    public Valign getImageValign() {
        return this.imageValign;
    }

    @Override
    public void render(Graphics2D g) {
        BufferedImage img;
        if (this.isSuspended() || !this.isVisible()) {
            return;
        }
        Image bg = this.getBackground();
        if (bg != null) {
            ImageRenderer.render(g, bg, this.getLocation());
        }
        if ((img = this.getImage()) != null) {
            ImageRenderer.render(g, img, this.getImageLocation(img));
        }
        super.render(g);
    }

    public void setImage(Image image) {
        this.baseImage = (BufferedImage)image;
        this.rescaleImage();
    }

    public void setImageScaleMode(ImageScaleMode imageScaleMode) {
        this.imageScaleMode = imageScaleMode;
        this.rescaleImage();
    }

    public void setSpritesheetScaleMode(ImageScaleMode spritesheetScaleMode) {
        this.spritesheetScaleMode = spritesheetScaleMode;
        this.rescaleImage();
    }

    public void setSpritesheetScaleFactor(float spritesheetScaleFactor) {
        this.spritesheetScaleFactor = spritesheetScaleFactor;
    }

    public void setSpritesheet(Spritesheet spr) {
        this.spritesheet = spr;
    }

    public void setSpritesheet(Spritesheet spr, ImageScaleMode scaleMode) {
        this.setSpritesheet(spr);
        this.setSpritesheetScaleMode(scaleMode);
    }

    public void setSpritesheet(Spritesheet spr, ImageScaleMode scaleMode, float scaleFactor) {
        this.setSpritesheet(spr, scaleMode);
        this.setSpritesheetScaleFactor(scaleFactor);
    }

    public void setImageAlign(Align imageAlign) {
        this.imageAlign = imageAlign;
    }

    public void setImageValign(Valign imageValign) {
        this.imageValign = imageValign;
    }

    @Override
    public void setHeight(double height) {
        super.setHeight(height);
        this.rescaleImage();
    }

    @Override
    public void setWidth(double width) {
        super.setWidth(width);
        this.rescaleImage();
    }

    protected Spritesheet getSpritesheet() {
        return this.spritesheet;
    }

    private Point2D getImageLocation(Image img) {
        double x = this.getX();
        double y = this.getY();
        if (this.getImageScaleMode() == ImageScaleMode.STRETCH) {
            return new Point2D.Double(x, y);
        }
        if (this.getImageAlign() == Align.RIGHT) {
            x = x + this.getWidth() - (double)img.getWidth(null);
        } else if (this.getImageAlign() == Align.CENTER) {
            x = x + this.getWidth() / 2.0 - (double)img.getWidth(null) / 2.0;
        }
        if (this.getImageValign() == Valign.DOWN) {
            y = y + this.getHeight() - (double)img.getHeight(null);
        } else if (this.getImageValign() == Valign.MIDDLE) {
            y = y + this.getHeight() / 2.0 - (double)img.getHeight(null) / 2.0;
        }
        return new Point2D.Double(x, y);
    }
}

