/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class MathUtilities {
    private MathUtilities() {
        throw new UnsupportedOperationException();
    }

    public static boolean equals(double d1, double d2, double epsilon) {
        return Math.abs(d1 - d2) <= epsilon;
    }

    public static float round(float value, int places) {
        return (float)MathUtilities.round((double)value, places);
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    public static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    public static byte clamp(byte value, byte min, byte max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static short clamp(short value, short min, short max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static long clamp(long value, long min, long max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double getAverage(double[] numbers) {
        double sum = 0.0;
        for (double number : numbers) {
            if (number == 0.0) continue;
            sum += number;
        }
        return sum / (double)numbers.length;
    }

    public static float getAverage(float[] numbers) {
        float sum = 0.0f;
        for (float number : numbers) {
            if (number == 0.0f) continue;
            sum += number;
        }
        return sum / (float)numbers.length;
    }

    public static int getAverage(int[] numbers) {
        int sum = 0;
        for (int number : numbers) {
            if (number == 0) continue;
            sum += number;
        }
        return sum / numbers.length;
    }

    public static int getMax(int ... numbers) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < numbers.length; ++i) {
            if (numbers[i] <= max) continue;
            max = numbers[i];
        }
        return max;
    }

    public static boolean isInt(double value) {
        return value == Math.floor(value) && !Double.isInfinite(value);
    }

    public static boolean isOddNumber(int num) {
        return (num & 1) != 0;
    }

    public static int getFullPercent(double value, double fraction) {
        if (value == 0.0) {
            return 0;
        }
        return (int)(fraction * 100.0 / value);
    }

    public static double getPercent(double value, double fraction) {
        if (value == 0.0) {
            return 0.0;
        }
        return (double)((float)fraction * 100.0f) / value;
    }
}

