/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.sound;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.ILaunchable;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.sound.LoopedTrack;
import de.gurkenlabs.litiengine.sound.MusicPlayback;
import de.gurkenlabs.litiengine.sound.SFXPlayback;
import de.gurkenlabs.litiengine.sound.Sound;
import de.gurkenlabs.litiengine.sound.Track;
import de.gurkenlabs.litiengine.tweening.TweenFunction;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.LineUnavailableException;

public final class SoundEngine
implements IUpdateable,
ILaunchable {
    public static final int DEFAULT_MAX_DISTANCE = 150;
    static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(new ThreadFactory(){
        private int id = 0;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Sound Playback Thread " + ++this.id);
        }
    });
    private static final Logger log = Logger.getLogger(SoundEngine.class.getName());
    private Point2D listenerLocation;
    private UnaryOperator<Point2D> listenerLocationCallback = old -> Game.world().camera().getFocus();
    private int maxDist = 150;
    private MusicPlayback music;
    private final Collection<MusicPlayback> allMusic = ConcurrentHashMap.newKeySet();
    private final Collection<SFXPlayback> sounds = ConcurrentHashMap.newKeySet();

    public SoundEngine() {
        if (Game.audio() != null) {
            throw new UnsupportedOperationException("Never initialize a SoundEngine manually. Use Game.audio() instead.");
        }
    }

    public int getMaxDistance() {
        return this.maxDist;
    }

    public MusicPlayback playMusic(String musicName) {
        return this.playMusic((Sound)Resources.sounds().get(musicName));
    }

    public MusicPlayback playMusic(Sound music) {
        return this.playMusic(new LoopedTrack(music));
    }

    public MusicPlayback playMusic(Track track) {
        return this.playMusic(track, null, false, true);
    }

    public MusicPlayback playMusic(Track track, boolean restart) {
        return this.playMusic(track, null, restart, true);
    }

    public MusicPlayback playMusic(Track track, boolean restart, boolean stop) {
        return this.playMusic(track, null, restart, stop);
    }

    public synchronized MusicPlayback playMusic(Track track, Consumer<? super MusicPlayback> config, boolean restart, boolean stop) {
        if (!restart && this.music != null && this.music.isPlaying() && this.music.getTrack().equals(track)) {
            return this.music;
        }
        try {
            MusicPlayback playback = new MusicPlayback(track);
            if (config != null) {
                config.accept(playback);
            }
            if (stop) {
                this.stopMusic();
            }
            this.allMusic.add(playback);
            playback.start();
            this.music = playback;
            return playback;
        }
        catch (IllegalArgumentException | LineUnavailableException e) {
            SoundEngine.resourceFailure(e);
            return null;
        }
    }

    public void fadeMusic(int duration) {
        this.allMusic.forEach(m -> m.fade(duration));
    }

    public void fadeMusic(int duration, float target, TweenFunction easeType) {
        this.allMusic.forEach(m -> m.fade(duration, target, easeType));
    }

    public synchronized MusicPlayback getMusic() {
        return this.music;
    }

    public synchronized Collection<MusicPlayback> getAllMusic() {
        return Collections.unmodifiableCollection(this.allMusic);
    }

    public SFXPlayback playSound(Sound sound, IEntity entity) {
        return this.playSound(sound, entity, false);
    }

    public SFXPlayback playSound(String soundName, IEntity entity) {
        return this.playSound((Sound)Resources.sounds().get(soundName), entity, false);
    }

    public SFXPlayback playSound(Sound sound, IEntity entity, boolean loop) {
        return this.playSound(sound, entity, loop, this.getMaxDistance(), 1.0f);
    }

    public SFXPlayback playSound(Sound sound, IEntity entity, boolean loop, int range) {
        return this.playSound(sound, entity::getCenter, loop, range, 1.0f);
    }

    public SFXPlayback playSound(Sound sound, IEntity entity, boolean loop, int range, float volume) {
        return this.playSound(sound, entity::getCenter, loop, range, volume);
    }

    public SFXPlayback playSound(String soundName, IEntity entity, boolean loop) {
        return this.playSound((Sound)Resources.sounds().get(soundName), entity, loop);
    }

    public SFXPlayback playSound(Sound sound, Point2D location) {
        return this.playSound(sound, location, false);
    }

    public SFXPlayback playSound(String soundName, Point2D location) {
        return this.playSound((Sound)Resources.sounds().get(soundName), location, false);
    }

    public SFXPlayback playSound(Sound sound, double x, double y) {
        return this.playSound(sound, (Point2D)new Point2D.Double(x, y), false);
    }

    public SFXPlayback playSound(String soundName, double x, double y) {
        return this.playSound((Sound)Resources.sounds().get(soundName), (Point2D)new Point2D.Double(x, y), false);
    }

    public SFXPlayback playSound(Sound sound, Point2D location, boolean loop) {
        return this.playSound(sound, () -> location, loop, this.getMaxDistance(), 1.0f);
    }

    public SFXPlayback playSound(Sound sound, Point2D location, boolean loop, int range) {
        return this.playSound(sound, () -> location, loop, range, 1.0f);
    }

    public SFXPlayback playSound(Sound sound, Point2D location, boolean loop, int range, float volume) {
        return this.playSound(sound, () -> location, loop, range, volume);
    }

    public SFXPlayback playSound(String soundName, Point2D location, boolean loop) {
        return this.playSound((Sound)Resources.sounds().get(soundName), location, loop);
    }

    public SFXPlayback playSound(Sound sound, double x, double y, boolean loop) {
        return this.playSound(sound, (Point2D)new Point2D.Double(x, y), loop);
    }

    public SFXPlayback playSound(String soundName, double x, double y, boolean loop) {
        return this.playSound((Sound)Resources.sounds().get(soundName), (Point2D)new Point2D.Double(x, y), loop);
    }

    public SFXPlayback playSound(Sound sound) {
        return this.playSound(sound, false);
    }

    public SFXPlayback playSound(String soundName) {
        return this.playSound((Sound)Resources.sounds().get(soundName), false);
    }

    public SFXPlayback playSound(Sound sound, boolean loop) {
        return this.playSound(sound, () -> null, loop, this.getMaxDistance(), 1.0f);
    }

    public SFXPlayback playSound(Sound sound, boolean loop, int range) {
        return this.playSound(sound, () -> null, loop, range, 1.0f);
    }

    public SFXPlayback playSound(Sound sound, boolean loop, int range, float volume) {
        return this.playSound(sound, () -> null, loop, range, volume);
    }

    public SFXPlayback playSound(String soundName, boolean loop) {
        return this.playSound((Sound)Resources.sounds().get(soundName), loop);
    }

    public void setMaxDistance(int radius) {
        this.maxDist = radius;
    }

    public synchronized void stopMusic() {
        for (MusicPlayback track : this.allMusic) {
            track.cancel();
        }
    }

    public SFXPlayback createSound(Sound sound, Supplier<Point2D> supplier, boolean loop, int range, float volume) {
        try {
            return new SFXPlayback(sound, supplier, loop, range, volume);
        }
        catch (IllegalArgumentException | LineUnavailableException e) {
            SoundEngine.resourceFailure(e);
            return null;
        }
    }

    public void setListenerLocationCallback(UnaryOperator<Point2D> callback) {
        this.listenerLocationCallback = callback;
    }

    @Override
    public void start() {
        this.listenerLocation = Game.world().camera().getFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        if (this.music != null && this.music.isPlaying()) {
            this.music.cancel();
            this.music = null;
        }
        EXECUTOR.shutdown();
        Collection<SFXPlayback> collection = this.sounds;
        synchronized (collection) {
            for (SFXPlayback playback : this.sounds) {
                playback.cancel();
            }
            this.sounds.clear();
        }
    }

    @Override
    public void update() {
        this.listenerLocation = (Point2D)this.listenerLocationCallback.apply(this.listenerLocation);
        Iterator<SFXPlayback> iter = this.sounds.iterator();
        while (iter.hasNext()) {
            SFXPlayback s = iter.next();
            if (s.isPlaying()) {
                s.updateLocation(this.listenerLocation);
                continue;
            }
            iter.remove();
        }
        Iterator<MusicPlayback> iter2 = this.allMusic.iterator();
        while (iter.hasNext()) {
            MusicPlayback s = iter2.next();
            if (s.isPlaying()) {
                s.setMusicVolume(Game.config().sound().getMusicVolume());
                continue;
            }
            iter.remove();
        }
        if (this.music != null) {
            if (this.music.isPlaying()) {
                this.music.setMusicVolume(Game.config().sound().getMusicVolume());
            } else {
                this.music = null;
            }
        }
    }

    Point2D getListenerLocation() {
        return this.listenerLocation == null ? new Point2D.Double(0.0, 0.0) : (Point2D)this.listenerLocation.clone();
    }

    void addSound(SFXPlayback playback) {
        this.sounds.add(playback);
    }

    private SFXPlayback playSound(Sound sound, Supplier<Point2D> supplier, boolean loop, int range, float volume) {
        if (sound == null) {
            return null;
        }
        SFXPlayback playback = this.createSound(sound, supplier, loop, range, volume);
        if (playback == null) {
            return null;
        }
        playback.start();
        return playback;
    }

    private static void resourceFailure(Throwable e) {
        log.log(Level.WARNING, "could not open a line", e);
    }
}

