/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.Valign;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.graphics.FocusChangedEvent;
import de.gurkenlabs.litiengine.graphics.ZoomChangedEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventListener;

public interface ICamera
extends IUpdateable {
    public void onZoom(ZoomChangedListener var1);

    public void removeZoomListener(ZoomChangedListener var1);

    public void onFocus(FocusChangedListener var1);

    public void removeFocusListener(FocusChangedListener var1);

    public Point2D getFocus();

    public Point2D getMapLocation(Point2D var1);

    public double getPixelOffsetX();

    public double getPixelOffsetY();

    public Rectangle2D getViewport();

    public Point2D getViewportDimensionCenter(IEntity var1);

    public Point2D getViewportLocation(double var1, double var3);

    default public Point2D getViewportLocation(IEntity entity) {
        Point2D entityLocation = entity.getLocation();
        return this.getViewportLocation(entityLocation.getX(), entityLocation.getY());
    }

    default public Point2D getViewportLocation(Point2D point) {
        return this.getViewportLocation(point.getX(), point.getY());
    }

    default public float getRenderScale() {
        return Game.graphics().getBaseRenderScale() * Game.window().getResolutionScale() * this.getZoom();
    }

    public float getZoom();

    default public void setFocus(Point2D focus) {
        this.setFocus(focus.getX(), focus.getY());
    }

    public void setFocus(double var1, double var3);

    public void pan(Point2D var1, int var2);

    public void pan(double var1, double var3, int var5);

    public void setZoom(float var1, int var2);

    public boolean isClampToMap();

    public void setClampToMap(boolean var1);

    public void setClampAlign(Align var1, Valign var2);

    public Align getClampAlign();

    public Valign getClampValign();

    public void shake(double var1, int var3, int var4);

    public void updateFocus();

    @FunctionalInterface
    public static interface FocusChangedListener
    extends EventListener {
        public void focusChanged(FocusChangedEvent var1);
    }

    @FunctionalInterface
    public static interface ZoomChangedListener
    extends EventListener {
        public void zoomChanged(ZoomChangedEvent var1);
    }
}

