/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.Trigger;
import de.gurkenlabs.litiengine.environment.Environment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import java.util.ArrayList;
import java.util.Collection;

public class TriggerMapObjectLoader
extends MapObjectLoader {
    protected TriggerMapObjectLoader() {
        super(MapObjectType.TRIGGER);
    }

    @Override
    public Collection<IEntity> load(Environment environment, IMapObject mapObject) {
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        if (!this.isMatchingType(mapObject)) {
            return entities;
        }
        String message = mapObject.getStringValue("triggermessage");
        Trigger.TriggerActivation act = mapObject.getStringValue("triggerActivation") != null ? Trigger.TriggerActivation.valueOf(mapObject.getStringValue("triggerActivation")) : Trigger.TriggerActivation.COLLISION;
        boolean oneTime = mapObject.getBoolValue("triggerOneTime");
        int coolDown = mapObject.getIntValue("triggerCooldown");
        Trigger trigger = this.createTrigger(mapObject, act, message, oneTime, coolDown);
        TriggerMapObjectLoader.loadDefaultProperties(trigger, mapObject);
        this.loadTargets(mapObject, trigger);
        this.loadActivators(mapObject, trigger);
        entities.add(trigger);
        return entities;
    }

    protected Trigger createTrigger(IMapObject mapObject, Trigger.TriggerActivation act, String message, boolean oneTime, int coolDown) {
        return new Trigger(act, message, oneTime, coolDown);
    }

    protected void loadTargets(IMapObject mapObject, Trigger trigger) {
        String targets = mapObject.getStringValue("triggerTarget");
        for (int target : ArrayUtilities.splitInt(targets)) {
            if (target == 0) continue;
            trigger.addTarget(target);
        }
    }

    protected void loadActivators(IMapObject mapObject, Trigger trigger) {
        String activators = mapObject.getStringValue("triggerActivators");
        for (int activator : ArrayUtilities.splitInt(activators)) {
            if (activator == 0) continue;
            trigger.addActivator(activator);
        }
    }
}

