/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.configuration;

import de.gurkenlabs.litiengine.configuration.ConfigurationGroupInfo;
import de.gurkenlabs.litiengine.util.ReflectionUtilities;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.EventListener;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@ConfigurationGroupInfo
public abstract class ConfigurationGroup {
    private static final Logger log = Logger.getLogger(ConfigurationGroup.class.getName());
    private final Collection<ConfigurationChangedListener> listeners = ConcurrentHashMap.newKeySet();
    private final String prefix;
    private boolean debug;

    protected ConfigurationGroup() {
        ConfigurationGroupInfo info = this.getClass().getAnnotation(ConfigurationGroupInfo.class);
        this.prefix = info.prefix();
        this.debug = info.debug();
    }

    public void onChanged(ConfigurationChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ConfigurationChangedListener listener) {
        this.listeners.remove(listener);
    }

    public String getPrefix() {
        return this.prefix != null ? this.prefix : "";
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.set("debug", debug);
    }

    protected void initializeByProperty(String key, String value) {
        String propertyName = key.substring(this.getPrefix().length());
        ReflectionUtilities.setFieldValue(this.getClass(), this, propertyName, value);
    }

    protected void storeProperties(Properties properties) {
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                String value;
                if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                String propertyKey = this.getPrefix() + field.getName();
                if (field.getType().equals(Boolean.TYPE)) {
                    properties.setProperty(propertyKey, Boolean.toString(field.getBoolean(this)));
                    continue;
                }
                if (field.getType().equals(Integer.TYPE)) {
                    properties.setProperty(propertyKey, Integer.toString(field.getInt(this)));
                    continue;
                }
                if (field.getType().equals(Float.TYPE)) {
                    properties.setProperty(propertyKey, Float.toString(field.getFloat(this)));
                    continue;
                }
                if (field.getType().equals(Double.TYPE)) {
                    properties.setProperty(propertyKey, Double.toString(field.getDouble(this)));
                    continue;
                }
                if (field.getType().equals(Byte.TYPE)) {
                    properties.setProperty(propertyKey, Byte.toString(field.getByte(this)));
                    continue;
                }
                if (field.getType().equals(Short.TYPE)) {
                    properties.setProperty(propertyKey, Short.toString(field.getShort(this)));
                    continue;
                }
                if (field.getType().equals(Long.TYPE)) {
                    properties.setProperty(propertyKey, Long.toString(field.getLong(this)));
                    continue;
                }
                if (field.getType().equals(String.class)) {
                    properties.setProperty(propertyKey, field.get(this) != null ? (String)field.get(this) : "");
                    continue;
                }
                if (field.getType().equals(String[].class)) {
                    if (field.get(this) == null) {
                        properties.setProperty(propertyKey, "");
                        continue;
                    }
                    CharSequence[] arr = (String[])field.get(this);
                    value = String.join((CharSequence)",", arr);
                    value = value.replace("null", "");
                    properties.setProperty(propertyKey, value);
                    continue;
                }
                if (!field.getType().isEnum()) continue;
                Object val = field.get(this);
                value = val == null && field.getType().getEnumConstants().length > 0 ? field.getType().getEnumConstants()[0].toString() : "";
                properties.setProperty(propertyKey, val != null ? val.toString() : value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected <T> void set(String fieldName, T value) {
        Field field = ReflectionUtilities.getField(this.getClass(), fieldName, true);
        if (field != null) {
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                Object currentValue = field.get(this);
                PropertyChangeEvent event = new PropertyChangeEvent(this, fieldName, currentValue, value);
                field.set(this, value);
                for (ConfigurationChangedListener listener : this.listeners) {
                    listener.configurationChanged(event);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    @FunctionalInterface
    public static interface ConfigurationChangedListener
    extends EventListener {
        public void configurationChanged(PropertyChangeEvent var1);
    }
}

