/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.configuration;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.configuration.CleanProperties;
import de.gurkenlabs.litiengine.configuration.ConfigurationGroup;
import de.gurkenlabs.litiengine.configuration.ConfigurationGroupInfo;
import de.gurkenlabs.litiengine.resources.Resources;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Configuration {
    private static final Logger log = Logger.getLogger(Configuration.class.getName());
    private static final String DEFAULT_CONFIGURATION_FILE_NAME = "config.properties";
    private final List<ConfigurationGroup> configurationGroups;
    private final String fileName;

    public Configuration(ConfigurationGroup ... configurationGroups) {
        this(DEFAULT_CONFIGURATION_FILE_NAME, configurationGroups);
    }

    public Configuration(String fileName, ConfigurationGroup ... configurationGroups) {
        this.fileName = fileName;
        this.configurationGroups = new ArrayList<ConfigurationGroup>();
        if (configurationGroups != null && configurationGroups.length > 0) {
            for (ConfigurationGroup group : configurationGroups) {
                this.configurationGroups.add(group);
            }
        }
    }

    public <T extends ConfigurationGroup> T getConfigurationGroup(Class<T> groupClass) {
        for (ConfigurationGroup group : this.getConfigurationGroups()) {
            if (!group.getClass().equals(groupClass)) continue;
            return (T)((ConfigurationGroup)groupClass.cast(group));
        }
        return null;
    }

    public ConfigurationGroup getConfigurationGroup(String prefix) {
        for (ConfigurationGroup group : this.getConfigurationGroups()) {
            ConfigurationGroupInfo info = group.getClass().getAnnotation(ConfigurationGroupInfo.class);
            if (info == null || !info.prefix().equals(prefix)) continue;
            return group;
        }
        return null;
    }

    public List<ConfigurationGroup> getConfigurationGroups() {
        return this.configurationGroups;
    }

    public void add(ConfigurationGroup group) {
        this.getConfigurationGroups().add(group);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void load() {
        InputStream settingsStream;
        File settingsFile;
        block21: {
            settingsFile = new File(this.getFileName());
            try {
                settingsStream = Resources.get(this.getFileName());
                try {
                    if ((settingsFile.exists() || settingsStream != null) && settingsFile.isFile()) break block21;
                    try (FileOutputStream out = new FileOutputStream(settingsFile);){
                        this.createDefaultSettingsFile(out);
                    }
                    log.log(Level.INFO, "Default configuration {0} created", this.getFileName());
                    return;
                }
                finally {
                    if (settingsStream != null) {
                        settingsStream.close();
                    }
                }
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (settingsFile.exists()) {
            try {
                settingsStream = new FileInputStream(settingsFile);
                try {
                    Properties properties = new Properties();
                    BufferedInputStream stream = new BufferedInputStream(settingsStream);
                    properties.load(stream);
                    stream.close();
                    this.initializeSettingsByProperties(properties);
                    log.log(Level.INFO, "Configuration {0} created", this.getFileName());
                }
                finally {
                    settingsStream.close();
                }
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void save() {
        File settingsFile = new File(this.getFileName());
        try (FileOutputStream out = new FileOutputStream(settingsFile, false);){
            for (ConfigurationGroup group : this.getConfigurationGroups()) {
                if (!Game.isDebug() && group.isDebug()) continue;
                Configuration.storeConfigurationGroup(out, group);
            }
            log.log(Level.INFO, "Configuration {0} saved", this.getFileName());
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private static void storeConfigurationGroup(OutputStream out, ConfigurationGroup group) {
        try {
            CleanProperties groupProperties = new CleanProperties();
            group.storeProperties(groupProperties);
            ((Properties)groupProperties).store(out, group.getPrefix() + "SETTINGS");
            out.flush();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void createDefaultSettingsFile(OutputStream out) {
        for (ConfigurationGroup group : this.getConfigurationGroups()) {
            Configuration.storeConfigurationGroup(out, group);
        }
    }

    private void initializeSettingsByProperties(Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            for (ConfigurationGroup group : this.getConfigurationGroups()) {
                if (!key.startsWith(group.getPrefix())) continue;
                group.initializeByProperty(key, properties.getProperty(key));
            }
        }
    }
}

