/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.resources;

import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.resources.ResourcesContainer;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Fonts
extends ResourcesContainer<Font> {
    private static final Logger log = Logger.getLogger(Fonts.class.getName());

    Fonts() {
    }

    public Font get(String name, float size) {
        Font font = (Font)this.get(name);
        if (font == null) {
            return null;
        }
        return font.deriveFont(size);
    }

    public Font get(String name, int style) {
        Font font = (Font)this.get(name);
        if (font == null) {
            return null;
        }
        return font.deriveFont(style);
    }

    public Font get(String name, int style, float size) {
        Font font = (Font)this.get(name);
        if (font == null) {
            return null;
        }
        return font.deriveFont(style, size);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Font load(URL resourceName) {
        try (InputStream fontStream = Resources.get(resourceName);){
            if (fontStream == null) {
                log.log(Level.SEVERE, "font {0} could not be loaded", resourceName);
                Font font2 = null;
                return font2;
            }
            Font font = Font.createFont(0, fontStream);
            return font;
        }
        catch (FontFormatException | IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }
}

