/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.emitters.xml;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;

@XmlRootElement(name="param")
public class ParticleParameter
implements Serializable {
    private static final long serialVersionUID = 4893417265998349179L;
    @XmlAttribute
    private double maxValue;
    @XmlAttribute
    private double minValue;

    public ParticleParameter() {
    }

    public ParticleParameter(float value) {
        this.setMinValue(value);
        this.setMaxValue(value);
    }

    public ParticleParameter(float minValue, float maxValue) {
        this.setMinValue(minValue);
        this.setMaxValue(maxValue);
    }

    public double get() {
        if (this.minValue < this.maxValue) {
            return this.getRandomNumber();
        }
        return this.getMinValue();
    }

    @XmlTransient
    public double getMaxValue() {
        return this.maxValue;
    }

    @XmlTransient
    public double getMinValue() {
        return this.minValue;
    }

    @XmlTransient
    public float getRandomNumber() {
        return (float)ThreadLocalRandom.current().nextDouble(this.getMinValue(), this.getMaxValue());
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }
}

