/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.Valign;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.graphics.FocusChangedEvent;
import de.gurkenlabs.litiengine.graphics.ICamera;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.graphics.ZoomChangedEvent;
import de.gurkenlabs.litiengine.graphics.animation.IEntityAnimationController;
import de.gurkenlabs.litiengine.util.MathUtilities;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;

public class Camera
implements ICamera {
    private final Collection<ICamera.ZoomChangedListener> zoomListeners = ConcurrentHashMap.newKeySet();
    private final Collection<ICamera.FocusChangedListener> focusChangedListeners = ConcurrentHashMap.newKeySet();
    private Point2D focus;
    private long lastShake;
    private int shakeDelay;
    private int shakeDuration = 2;
    private double shakeIntensity = 1.0;
    private double shakeOffsetX;
    private double shakeOffsetY;
    private long shakeTick;
    private Rectangle2D viewport;
    private float zoom = 1.0f;
    private float targetZoom;
    private int zoomDelay;
    private float zoomStep;
    private long zoomTick;
    private Point2D targetFocus;
    private int panTime = 0;
    private boolean clampToMap;
    private Align align = Align.LEFT;
    private Valign valign = Valign.TOP;

    public Camera() {
        this.focus = new Point2D.Double();
        this.viewport = new Rectangle2D.Double();
    }

    @Override
    public Point2D getFocus() {
        return this.focus;
    }

    @Override
    public Point2D getMapLocation(Point2D viewPortLocation) {
        double x = viewPortLocation.getX() - this.getPixelOffsetX();
        double y = viewPortLocation.getY() - this.getPixelOffsetY();
        return new Point2D.Double(x, y);
    }

    @Override
    public double getPixelOffsetX() {
        return -this.viewport.getX();
    }

    @Override
    public double getPixelOffsetY() {
        return -this.viewport.getY();
    }

    @Override
    public Rectangle2D getViewport() {
        return (Rectangle2D)this.viewport.clone();
    }

    @Override
    public Point2D getViewportDimensionCenter(IEntity entity) {
        Point2D viewPortLocation = this.getViewportLocation(entity);
        IEntityAnimationController<?> animationController = entity.animations();
        if (animationController == null || animationController.getCurrent() == null) {
            return new Point2D.Double(viewPortLocation.getX() + entity.getWidth() * 0.5, viewPortLocation.getY() + entity.getHeight() * 0.5);
        }
        Spritesheet spriteSheet = animationController.getCurrent().getSpritesheet();
        if (spriteSheet == null) {
            return viewPortLocation;
        }
        return new Point2D.Double(viewPortLocation.getX() + (double)spriteSheet.getSpriteWidth() * 0.5, viewPortLocation.getY() + (double)spriteSheet.getSpriteHeight() * 0.5);
    }

    @Override
    public Point2D getViewportLocation(double x, double y) {
        return new Point2D.Double(x + this.getPixelOffsetX(), y + this.getPixelOffsetY());
    }

    @Override
    public float getZoom() {
        return this.zoom;
    }

    @Override
    public void onZoom(ICamera.ZoomChangedListener listener) {
        this.zoomListeners.add(listener);
    }

    @Override
    public void removeZoomListener(ICamera.ZoomChangedListener listener) {
        this.zoomListeners.remove(listener);
    }

    @Override
    public void onFocus(ICamera.FocusChangedListener listener) {
        this.focusChangedListeners.add(listener);
    }

    @Override
    public void removeFocusListener(ICamera.FocusChangedListener listener) {
        this.focusChangedListeners.remove(listener);
    }

    @Override
    public void setFocus(Point2D focus) {
        this.focus = this.clampToMap(focus);
        double fraction = this.focus.getY() - Math.floor(this.focus.getY());
        if (MathUtilities.isInt(fraction * 4.0)) {
            this.focus.setLocation(this.focus.getX(), this.focus.getY() + 0.01);
        }
        FocusChangedEvent event = new FocusChangedEvent(this, this.focus);
        for (ICamera.FocusChangedListener listener : this.focusChangedListeners) {
            listener.focusChanged(event);
        }
    }

    @Override
    public void setFocus(double x, double y) {
        this.setFocus(new Point2D.Double(x, y));
    }

    @Override
    public void setZoom(float targetZoom, int delay) {
        if (delay == 0) {
            this.zoom = targetZoom;
            this.targetZoom = 0.0f;
            this.zoomDelay = 0;
            this.zoomTick = 0L;
            this.zoomStep = 0.0f;
            ZoomChangedEvent event = new ZoomChangedEvent(this, targetZoom);
            for (ICamera.ZoomChangedListener listener : this.zoomListeners) {
                listener.zoomChanged(event);
            }
        } else {
            this.zoomTick = Game.time().now();
            this.targetZoom = targetZoom;
            this.zoomDelay = delay;
            double tickduration = 1000.0 / (double)Game.loop().getTickRate();
            double tickAmount = (double)delay / tickduration;
            float totalDelta = this.targetZoom - this.zoom;
            this.zoomStep = tickAmount > 0.0 ? (float)((double)totalDelta / tickAmount) : totalDelta;
        }
    }

    @Override
    public void shake(double intensity, int delay, int shakeDuration) {
        this.shakeTick = Game.time().now();
        this.shakeDelay = delay;
        this.shakeIntensity = intensity;
        this.shakeDuration = shakeDuration;
    }

    @Override
    public void update() {
        if (Game.world().camera() != null && !Game.world().camera().equals(this)) {
            return;
        }
        if (this.targetZoom > 0.0f) {
            if (Game.time().since(this.zoomTick) >= (long)this.zoomDelay) {
                this.zoom = this.targetZoom;
                this.targetZoom = 0.0f;
                this.zoomDelay = 0;
                this.zoomTick = 0L;
                this.zoomStep = 0.0f;
            } else {
                this.zoom += this.zoomStep;
            }
            ZoomChangedEvent event = new ZoomChangedEvent(this, this.getZoom());
            for (ICamera.ZoomChangedListener listener : this.zoomListeners) {
                listener.zoomChanged(event);
            }
        }
        if (this.panTime > 0) {
            if (--this.panTime <= 0) {
                this.setFocus(this.targetFocus);
                this.targetFocus = null;
            } else {
                double diff = (double)this.panTime / ((double)this.panTime + 1.0);
                this.focus = new Point2D.Double(this.focus.getX() * diff + this.targetFocus.getX() * (1.0 - diff), this.focus.getY() * diff + this.targetFocus.getY() * (1.0 - diff));
            }
        }
        if (!this.isShakeEffectActive()) {
            this.shakeOffsetX = 0.0;
            this.shakeOffsetY = 0.0;
            return;
        }
        if (Game.time().since(this.lastShake) > (long)this.shakeDelay) {
            this.shakeOffsetX = this.getShakeIntensity() * ThreadLocalRandom.current().nextGaussian();
            this.shakeOffsetY = this.getShakeIntensity() * ThreadLocalRandom.current().nextGaussian();
            this.lastShake = Game.time().now();
        }
    }

    @Override
    public void updateFocus() {
        Point2D shook = this.applyShakeEffect(this.getFocus());
        double viewPortX = shook.getX() - this.getViewPortCenterX();
        double viewPortY = shook.getY() - this.getViewPortCenterY();
        this.viewport.setFrame(viewPortX, viewPortY, this.getViewportWidth(), this.getViewportHeight());
    }

    @Override
    public boolean isClampToMap() {
        return this.clampToMap;
    }

    @Override
    public void setClampToMap(boolean clampToMap) {
        this.clampToMap = clampToMap;
    }

    @Override
    public void setClampAlign(Align align, Valign valign) {
        this.align = Objects.requireNonNull(align);
        this.valign = Objects.requireNonNull(valign);
    }

    @Override
    public Align getClampAlign() {
        return this.align;
    }

    @Override
    public Valign getClampValign() {
        return this.valign;
    }

    @Override
    public void pan(Point2D focus, int duration) {
        this.targetFocus = this.clampToMap(focus);
        this.panTime = duration;
    }

    @Override
    public void pan(double x, double y, int duration) {
        this.pan(new Point2D.Double(x, y), duration);
    }

    protected Point2D clampToMap(Point2D focus) {
        if (Game.world().environment() == null || Game.world().environment().getMap() == null || !this.isClampToMap()) {
            return new Point2D.Double(focus.getX(), focus.getY());
        }
        Dimension mapSize = Game.world().environment().getMap().getSizeInPixels();
        double minX = this.getViewportWidth() / 2.0;
        double maxX = mapSize.getWidth() - minX;
        double minY = this.getViewportHeight() / 2.0;
        double maxY = mapSize.getHeight() - minY;
        double x = maxX < minX ? maxX + this.align.getValue(minX - maxX - mapSize.getWidth()) : MathUtilities.clamp(focus.getX(), minX, maxX);
        double y = maxY < minY ? maxY + this.valign.getValue(minY - maxY - mapSize.getHeight()) : MathUtilities.clamp(focus.getY(), minY, maxY);
        return new Point2D.Double(x, y);
    }

    protected int panTime() {
        return this.panTime;
    }

    protected double getViewportWidth() {
        return Game.window().getResolution().getWidth() / (double)this.getRenderScale();
    }

    protected double getViewportHeight() {
        return Game.window().getResolution().getHeight() / (double)this.getRenderScale();
    }

    private Point2D applyShakeEffect(Point2D cameraLocation) {
        if (this.isShakeEffectActive()) {
            return new Point2D.Double(cameraLocation.getX() + this.shakeOffsetX, cameraLocation.getY() + this.shakeOffsetY);
        }
        return cameraLocation;
    }

    private int getShakeDuration() {
        return this.shakeDuration;
    }

    private double getShakeIntensity() {
        return this.shakeIntensity;
    }

    private long getShakeTick() {
        return this.shakeTick;
    }

    private double getViewPortCenterX() {
        return this.getViewportWidth() * 0.5;
    }

    private double getViewPortCenterY() {
        return this.getViewportHeight() * 0.5;
    }

    private boolean isShakeEffectActive() {
        return this.getShakeTick() != 0L && Game.time().since(this.getShakeTick()) < (long)this.getShakeDuration();
    }
}

