/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Layer;
import de.gurkenlabs.litiengine.environment.tilemap.xml.MapObject;
import de.gurkenlabs.litiengine.environment.tilemap.xml.TmxException;
import de.gurkenlabs.litiengine.util.ColorHelper;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.awt.Color;
import java.awt.Dimension;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MapObjectLayer
extends Layer
implements IMapObjectLayer {
    public static final String DEFAULT_MAPOBJECTLAYER_NAME = "default";
    @XmlElement(name="object")
    private ArrayList<MapObject> objects = new ArrayList();
    @XmlAttribute
    private String color;
    private transient Color decodedColor;
    private transient List<IMapObject> mapObjects = new CopyOnWriteArrayList<IMapObject>();
    private transient boolean added;

    public MapObjectLayer() {
    }

    public MapObjectLayer(MapObjectLayer original) {
        super(original);
        int mapId = Game.world().environment().getNextMapId();
        for (IMapObject obj : original.getMapObjects()) {
            this.addMapObject(new MapObject((MapObject)obj, mapId));
            ++mapId;
        }
        if (original.getColor() != null) {
            this.setColor(original.getColorHexString());
        }
    }

    private void loadMapObjects() {
        if (!this.added) {
            if (this.objects != null) {
                this.mapObjects.addAll(this.objects);
            }
            this.added = true;
        }
    }

    @Override
    public List<IMapObject> getMapObjects() {
        this.loadMapObjects();
        return this.mapObjects;
    }

    @Override
    public void removeMapObject(IMapObject mapObject) {
        this.mapObjects.remove(mapObject);
        this.objects.remove(mapObject);
        if (mapObject instanceof MapObject) {
            ((MapObject)mapObject).setLayer(null);
        }
    }

    @Override
    public Dimension getSizeInTiles() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void addMapObject(IMapObject mapObject) {
        this.loadMapObjects();
        this.mapObjects.add(mapObject);
        if (mapObject instanceof MapObject) {
            MapObject obj = (MapObject)mapObject;
            if (obj.getLayer() != null && !obj.getLayer().equals(this)) {
                obj.getLayer().removeMapObject(obj);
            }
            this.objects.add(obj);
            obj.setLayer(this);
        }
    }

    @Override
    public Color getColor() {
        if (this.color == null || this.color.isEmpty()) {
            return null;
        }
        if (this.decodedColor != null) {
            return this.decodedColor;
        }
        this.decodedColor = ColorHelper.decode(this.color);
        return this.decodedColor;
    }

    @Override
    public String getColorHexString() {
        return this.color;
    }

    @Override
    public void setColor(String color) {
        this.color = color;
        this.decodedColor = null;
    }

    @Override
    public Collection<IMapObject> getMapObjects(String ... types) {
        ArrayList<IMapObject> objs = new ArrayList<IMapObject>();
        for (IMapObject mapObject : this.getMapObjects()) {
            if (mapObject == null || !Arrays.stream(types).anyMatch(type -> type.equals(mapObject.getType()))) continue;
            objs.add(mapObject);
        }
        return objs;
    }

    @Override
    public Collection<IMapObject> getMapObjects(int ... mapIDs) {
        ArrayList<IMapObject> objs = new ArrayList<IMapObject>();
        for (IMapObject mapObject : this.getMapObjects()) {
            if (mapObject == null || !Arrays.stream(mapIDs).anyMatch(id -> id == mapObject.getId())) continue;
            objs.add(mapObject);
        }
        return objs;
    }

    @Override
    protected void afterUnmarshal(Unmarshaller u, Object parent) {
        if (this.objects == null) {
            this.objects = new ArrayList();
        }
        super.afterUnmarshal(u, parent);
    }

    @Override
    void finish(URL location) throws TmxException {
        super.finish(location);
        for (MapObject object : this.objects) {
            object.finish(location);
        }
    }
}

