/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities.behavior;

import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.entities.behavior.State;
import de.gurkenlabs.litiengine.entities.behavior.Transition;
import java.util.Collections;
import java.util.List;

public class StateMachine
implements IUpdateable {
    private State currentState;

    public State getCurrentState() {
        return this.currentState;
    }

    public void setState(State newState) {
        if (this.currentState != null) {
            this.currentState.exit();
        }
        this.currentState = newState;
        this.currentState.enter();
    }

    @Override
    public void update() {
        if (this.currentState == null) {
            return;
        }
        this.currentState.perform();
        List<Transition> transitions = this.currentState.getTransitions();
        Collections.sort(transitions);
        for (Transition transition : transitions) {
            if (!transition.conditionsFullfilled()) continue;
            this.currentState.exit();
            this.currentState = transition.getNextState();
            this.currentState.enter();
            return;
        }
    }
}

