/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.abilities.effects;

import de.gurkenlabs.litiengine.abilities.Ability;
import de.gurkenlabs.litiengine.abilities.effects.Effect;
import de.gurkenlabs.litiengine.abilities.effects.EffectApplication;
import de.gurkenlabs.litiengine.abilities.effects.EffectTarget;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.physics.Force;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ForceEffect
extends Effect {
    private final float strength;
    private final Map<IMobileEntity, Force> appliedForces;

    protected ForceEffect(Ability ability, float strength, EffectTarget ... targets) {
        super(ability, targets);
        this.strength = strength;
        this.appliedForces = new ConcurrentHashMap<IMobileEntity, Force>();
    }

    @Override
    public void apply(ICombatEntity affectedEntity) {
        super.apply(affectedEntity);
        if (affectedEntity instanceof IMobileEntity) {
            IMobileEntity iMobileEntity = (IMobileEntity)((Object)affectedEntity);
            Force force = this.createForce(iMobileEntity);
            this.appliedForces.put(iMobileEntity, force);
            iMobileEntity.movement().apply(force);
        }
    }

    public float getStrength() {
        return this.strength;
    }

    protected abstract Force createForce(IMobileEntity var1);

    @Override
    public void cease(ICombatEntity entity) {
        IMobileEntity iMobileEntity;
        super.cease(entity);
        if (entity instanceof IMobileEntity && this.appliedForces.containsKey(iMobileEntity = (IMobileEntity)((Object)entity))) {
            this.appliedForces.get(iMobileEntity).end();
            this.appliedForces.remove(iMobileEntity);
        }
    }

    @Override
    protected boolean hasEnded(EffectApplication appliance) {
        return super.hasEnded(appliance) || this.appliedForces.isEmpty() || this.appliedForces.values().stream().allMatch(Force::hasEnded);
    }
}

