/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.environment.tilemap.xml.CustomPropertyProvider;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

@XmlRootElement(name="gameinfo")
public class GameInfo
extends CustomPropertyProvider {
    private static final Logger log = Logger.getLogger(GameInfo.class.getName());
    @XmlElement
    private String name = "LITIENGINE Game";
    @XmlElement
    private String subtitle = "The pure 2D java game engine";
    @XmlElement
    private String description = "A game, created with the allmighty LITIENGINE.";
    @XmlElement
    private String website = "https://litiengine.com";
    @XmlElement
    private String version = "v1.0";
    @XmlElement
    private String company = "gurkenlabs";
    @XmlElement
    private String publisher;
    @XmlElement(name="developer")
    private String[] developers = new String[]{"Steffen Wilke", "Matthias Wilke"};

    @XmlTransient
    public String getCompany() {
        return this.company;
    }

    @XmlTransient
    public String getDescription() {
        return this.description;
    }

    @XmlTransient
    public String getWebsite() {
        return this.website;
    }

    @XmlTransient
    public URL getWebsiteURL() {
        if (this.getWebsite() == null || this.getWebsite().isEmpty()) {
            return null;
        }
        try {
            return new URL(this.getWebsite());
        }
        catch (MalformedURLException e) {
            log.log(Level.WARNING, e, () -> this.getWebsite() + ": " + e.getMessage());
            return null;
        }
    }

    @XmlTransient
    public String[] getDevelopers() {
        return this.developers;
    }

    @XmlTransient
    public String getName() {
        return this.name;
    }

    @XmlTransient
    public String getPublisher() {
        return this.publisher;
    }

    @XmlTransient
    public String getSubTitle() {
        return this.subtitle;
    }

    @XmlTransient
    public String getVersion() {
        return this.version;
    }

    public String getTitle() {
        return this.getSubTitle() != null && !this.getSubTitle().isEmpty() ? this.getName() + " " + this.getVersion() + " - " + this.getSubTitle() : this.getName() + " " + this.getVersion();
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDevelopers(String ... developers) {
        this.developers = developers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSubTitle(String subTitle) {
        this.subtitle = subTitle;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setWebsite(String website) {
        this.website = website;
    }
}

