/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util.io;

import de.gurkenlabs.litiengine.util.io.URLAdapter;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;

public final class XmlUtilities {
    private static final Logger log = Logger.getLogger(XmlUtilities.class.getName());
    private static final Map<Class<?>, JAXBContext> jaxbContexts = new ConcurrentHashMap();

    private XmlUtilities() {
        throw new UnsupportedOperationException();
    }

    public static void saveWithCustomIndentation(ByteArrayInputStream input, FileOutputStream fos, int indentation) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("doctype-public", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indentation));
            SAXSource xmlSource = new SAXSource(new InputSource(input));
            StreamResult res = new StreamResult(fos);
            transformer.transform(xmlSource, res);
            fos.flush();
            fos.close();
        }
        catch (IOException | TransformerException | TransformerFactoryConfigurationError e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static <T> JAXBContext getContext(Class<T> cls) {
        try {
            JAXBContext jaxbContext;
            if (jaxbContexts.containsKey(cls)) {
                jaxbContext = jaxbContexts.get(cls);
            } else {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{cls});
                jaxbContexts.put(cls, jaxbContext);
            }
            return jaxbContext;
        }
        catch (JAXBException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static <T> T read(Class<T> cls, URL path) throws JAXBException {
        JAXBContext jaxbContext = XmlUtilities.getContext(cls);
        if (jaxbContext == null) {
            return null;
        }
        Unmarshaller um = jaxbContext.createUnmarshaller();
        um.setAdapter((XmlAdapter)new URLAdapter(path));
        return cls.cast(um.unmarshal(path));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File save(Object object, String fileName) {
        if (fileName == null) return null;
        if (fileName.isEmpty()) {
            return null;
        }
        File newFile = new File(fileName);
        try (FileOutputStream fileOut = new FileOutputStream(newFile);){
            JAXBContext jaxbContext = XmlUtilities.getContext(object.getClass());
            if (jaxbContext == null) {
                File file = null;
                return file;
            }
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)false);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            jaxbMarshaller.marshal(object, (OutputStream)out);
            XmlUtilities.saveWithCustomIndentation(new ByteArrayInputStream(out.toByteArray()), fileOut, 1);
            out.close();
            jaxbMarshaller.marshal(object, (OutputStream)out);
            return newFile;
        }
        catch (JAXBException | IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return newFile;
    }

    public static File save(Object object, String fileName, String extension) {
        Object fileNameWithExtension = fileName;
        if (!((String)fileNameWithExtension).endsWith("." + extension)) {
            fileNameWithExtension = (String)fileNameWithExtension + "." + extension;
        }
        return XmlUtilities.save(object, (String)fileNameWithExtension);
    }
}

