/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.Rotation;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.logging.Level;

public final class Imaging {
    public static final int CROP_ALIGN_CENTER = 0;
    public static final int CROP_ALIGN_LEFT = 1;
    public static final int CROP_ALIGN_RIGHT = 2;
    public static final int CROP_VALIGN_BOTTOM = 3;
    public static final int CROP_VALIGN_CENTER = 0;
    public static final int CROP_VALIGN_TOP = 1;
    public static final int CROP_VALIGN_TOPCENTER = 2;
    private static GraphicsConfiguration graphicsConfig;

    private Imaging() {
        throw new UnsupportedOperationException();
    }

    public static BufferedImage addShadow(BufferedImage image, int xOffset, int yOffset) {
        if (image == null) {
            return null;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (width == 0 || height == 0) {
            return image;
        }
        BufferedImage shadowImage = Imaging.flashVisiblePixels(image, new Color(0, 0, 0, 30));
        if (shadowImage == null) {
            return image;
        }
        AffineTransform tx = new AffineTransform();
        tx.concatenate(AffineTransform.getScaleInstance(1.0, -0.15));
        tx.concatenate(AffineTransform.getTranslateInstance(0.0, -shadowImage.getHeight()));
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        BufferedImage rotatedImage = op.filter(shadowImage, null);
        BufferedImage shadow = Imaging.getCompatibleImage(width, height + rotatedImage.getHeight() * 2);
        if (shadow == null) {
            return image;
        }
        Graphics2D g2D = shadow.createGraphics();
        g2D.drawImage((Image)rotatedImage, xOffset, yOffset + rotatedImage.getHeight(), null);
        g2D.drawImage((Image)image, 0, rotatedImage.getHeight(), null);
        g2D.dispose();
        return shadow;
    }

    public static BufferedImage applyAlphaChannel(BufferedImage img, final Color color) {
        if (color == null || img == null) {
            return img;
        }
        RGBImageFilter filter = new RGBImageFilter(){
            public final int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            @Override
            public int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(img.getSource(), filter);
        return Imaging.toBufferedImage(Toolkit.getDefaultToolkit().createImage(ip));
    }

    public static BufferedImage borderAlpha(BufferedImage image, Color strokeColor, boolean borderOnly) {
        BufferedImage bimage = Imaging.getCompatibleImage(image.getWidth(null) + 2, image.getHeight(null) + 2);
        if (bimage == null) {
            return image;
        }
        BufferedImage strokeImg = Imaging.flashVisiblePixels(image, strokeColor);
        Graphics2D graphics = bimage.createGraphics();
        graphics.drawImage((Image)strokeImg, 0, 1, null);
        graphics.drawImage((Image)strokeImg, 2, 1, null);
        graphics.drawImage((Image)strokeImg, 1, 0, null);
        graphics.drawImage((Image)strokeImg, 1, 2, null);
        Composite old = graphics.getComposite();
        graphics.setComposite(AlphaComposite.Clear);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = image.getRGB(x, y);
                if (pixel >> 24 == 0) continue;
                graphics.fillRect(x + 1, y + 1, 1, 1);
            }
        }
        if (!borderOnly) {
            graphics.setComposite(old);
            graphics.drawImage((Image)image, 1, 1, null);
        }
        graphics.dispose();
        return bimage;
    }

    public static boolean isEmpty(BufferedImage image) {
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = image.getRGB(x, y);
                if (pixel >> 24 == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean areEqual(BufferedImage image1, BufferedImage image2) {
        if (image1.getWidth() != image2.getWidth() || image1.getHeight() != image2.getHeight()) {
            return false;
        }
        for (int x = 1; x < image2.getWidth(); ++x) {
            for (int y = 1; y < image2.getHeight(); ++y) {
                if (image1.getRGB(x, y) == image2.getRGB(x, y)) continue;
                return false;
            }
        }
        return true;
    }

    public static BufferedImage crop(BufferedImage image, int cropAlignment, int cropVerticlaAlignment, int width, int height) {
        if (width > image.getWidth() || height > image.getHeight()) {
            return image;
        }
        return image.getSubimage(switch (cropAlignment) {
            case 0 -> image.getWidth() / 2 - width / 2;
            case 2 -> image.getWidth() - width;
            default -> 0;
        }, switch (cropVerticlaAlignment) {
            case 0 -> image.getHeight() / 2 - height / 2;
            case 3 -> image.getHeight() - height;
            case 2 -> image.getHeight() / 2 - height;
            default -> 0;
        }, width, height);
    }

    public static BufferedImage flashVisiblePixels(Image image, Color flashColor) {
        BufferedImage bimage = Imaging.getCompatibleImage(image.getWidth(null), image.getHeight(null));
        if (bimage == null) {
            return null;
        }
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(image, 0, 0, null);
        bGr.dispose();
        for (int y = 0; y < bimage.getHeight(); ++y) {
            for (int x = 0; x < bimage.getWidth(); ++x) {
                int pixel = bimage.getRGB(x, y);
                if (pixel >> 24 == 0) continue;
                bimage.setRGB(x, y, flashColor.getRGB());
            }
        }
        return bimage;
    }

    public static BufferedImage flipSpritesHorizontally(Spritesheet sprite) {
        return Imaging.flipSprites(sprite, Imaging::horizontalFlip);
    }

    public static BufferedImage flipSpritesVertically(Spritesheet sprite) {
        return Imaging.flipSprites(sprite, Imaging::verticalFlip);
    }

    public static BufferedImage nineSlice(BufferedImage image, int sliceWidth, int sliceHeight, int targetWidth, int targetHeight, float scaleFactor) {
        int targetSliceWidth = (int)((float)sliceWidth * scaleFactor);
        int targetSliceHeight = (int)((float)sliceHeight * scaleFactor);
        BufferedImage img = Imaging.getCompatibleImage(targetWidth, targetHeight);
        Graphics2D g = img.createGraphics();
        BufferedImage[][] slices = Imaging.getSubImages(image, 3, 3);
        g.drawImage(slices[0][0], 0, 0, targetSliceWidth, targetSliceHeight, null);
        g.drawImage(slices[0][2], targetWidth - targetSliceWidth, 0, targetSliceWidth, targetSliceHeight, null);
        g.drawImage(slices[2][0], 0, targetHeight - targetSliceHeight, targetSliceWidth, targetSliceHeight, null);
        g.drawImage(slices[2][2], targetWidth - targetSliceWidth, targetHeight - targetSliceHeight, targetSliceWidth, targetSliceHeight, null);
        g.drawImage(slices[0][1], targetSliceWidth, 0, targetWidth - 2 * targetSliceWidth, targetSliceHeight, null);
        g.drawImage(slices[2][1], targetSliceWidth, targetHeight - targetSliceHeight, targetWidth - 2 * targetSliceWidth, targetSliceHeight, null);
        g.drawImage(slices[1][0], 0, targetSliceHeight, targetSliceWidth, targetHeight - 2 * targetSliceHeight, null);
        g.drawImage(slices[1][2], targetWidth - targetSliceWidth, targetSliceHeight, targetSliceWidth, targetHeight - 2 * targetSliceHeight, null);
        g.drawImage(slices[1][1], targetSliceWidth, targetSliceHeight, targetWidth - 2 * targetSliceWidth, targetHeight - 2 * targetSliceHeight, null);
        g.dispose();
        return img;
    }

    public static BufferedImage nineSlice(Spritesheet spritesheet, int targetWidth, int targetHeight, float scaleFactor) {
        return Imaging.nineSlice(spritesheet.getImage(), spritesheet.getSpriteWidth(), spritesheet.getSpriteHeight(), targetWidth, targetHeight, scaleFactor);
    }

    public static BufferedImage copy(BufferedImage image) {
        ColorModel cm = image.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = image.copyData(image.getRaster().createCompatibleWritableRaster());
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    public static BufferedImage getCompatibleImage(int width, int height) {
        if (width == 0 || height == 0) {
            return null;
        }
        if (graphicsConfig == null) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice device = env.getDefaultScreenDevice();
            graphicsConfig = device.getDefaultConfiguration();
        }
        return graphicsConfig.createCompatibleImage(width, height, 3);
    }

    public static BufferedImage[][] getSubImages(BufferedImage image, int rows, int columns) {
        BufferedImage[][] smallImages = new BufferedImage[rows][columns];
        int smallWidth = image.getWidth() / columns;
        int smallHeight = image.getHeight() / rows;
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < columns; ++x) {
                int cellX = x * smallWidth;
                int cellY = y * smallHeight;
                smallImages[y][x] = image.getSubimage(cellX, cellY, smallWidth, smallHeight);
            }
        }
        return smallImages;
    }

    public static BufferedImage horizontalFlip(BufferedImage img) {
        int w = img.getWidth();
        int h = img.getHeight();
        if (w == 0 || h == 0) {
            return img;
        }
        BufferedImage dimg = Imaging.getCompatibleImage(w, h);
        Graphics2D g = Objects.requireNonNull(dimg).createGraphics();
        g.drawImage(img, 0, 0, w, h, w, 0, 0, h, null);
        g.dispose();
        return dimg;
    }

    public static BufferedImage verticalFlip(BufferedImage img) {
        int w = img.getWidth();
        int h = img.getHeight();
        if (w == 0 || h == 0) {
            return img;
        }
        BufferedImage dimg = Imaging.getCompatibleImage(w, h);
        Graphics2D g = Objects.requireNonNull(dimg).createGraphics();
        g.drawImage(img, 0, h, w, -h, null);
        g.dispose();
        return dimg;
    }

    public static BufferedImage replaceColors(BufferedImage bufferedImage, Map<Color, Color> colorMappings) {
        BufferedImage recoloredImage = Imaging.copy(bufferedImage);
        for (Map.Entry<Color, Color> c : colorMappings.entrySet()) {
            for (int y = 0; y < recoloredImage.getHeight(); ++y) {
                for (int x = 0; x < recoloredImage.getWidth(); ++x) {
                    if (recoloredImage.getRGB(x, y) != c.getKey().getRGB()) continue;
                    int newColor = c.getValue().getRGB();
                    recoloredImage.setRGB(x, y, newColor);
                }
            }
        }
        return recoloredImage;
    }

    public static BufferedImage rotate(BufferedImage bufferedImage, Rotation rotation) {
        return Imaging.rotate(bufferedImage, rotation.getRadians());
    }

    public static BufferedImage rotate(BufferedImage bufferedImage, double radians) {
        int newHeight;
        int h;
        double sin = Math.abs(Math.sin(radians));
        double cos = Math.abs(Math.cos(radians));
        int w = bufferedImage.getWidth();
        int newWidth = (int)Math.floor((double)w * cos + (double)(h = bufferedImage.getHeight()) * sin);
        BufferedImage bimg = Imaging.getCompatibleImage(newWidth, newHeight = (int)Math.floor((double)h * cos + (double)w * sin));
        if (bimg == null) {
            return bufferedImage;
        }
        Graphics2D g = bimg.createGraphics();
        g.translate((double)(newWidth - w) / 2.0, (double)(newHeight - h) / 2.0);
        g.rotate(radians, (double)w / 2.0, (double)h / 2.0);
        g.drawRenderedImage(Imaging.toBufferedImage(bufferedImage), null);
        g.dispose();
        return bimg;
    }

    public static BufferedImage scale(BufferedImage image, int max) {
        Dimension2D newDimension = GeometricUtilities.scaleWithRatio(image.getWidth(), image.getHeight(), max);
        return Imaging.scale(image, (int)Objects.requireNonNull(newDimension).getWidth(), (int)Objects.requireNonNull(newDimension).getHeight());
    }

    public static BufferedImage scale(BufferedImage image, double factor) {
        return Imaging.scale(image, factor, 1);
    }

    public static BufferedImage scale(BufferedImage image, double factor, int interpolation) {
        return image == null ? null : Imaging.scale(image, (int)Math.ceil((double)image.getWidth() * factor), (int)Math.ceil((double)image.getHeight() * factor), interpolation);
    }

    public static BufferedImage scale(BufferedImage image, int width, int height) {
        return Imaging.scale(image, width, height, 1, false, false);
    }

    public static BufferedImage scale(BufferedImage image, int width, int height, boolean keepRatio) {
        return Imaging.scale(image, width, height, 1, keepRatio, false);
    }

    public static BufferedImage scale(BufferedImage image, int width, int height, boolean keepRatio, boolean fill) {
        return Imaging.scale(image, width, height, 1, keepRatio, fill);
    }

    public static BufferedImage scale(BufferedImage image, int width, int height, int interpolation, boolean keepRatio) {
        return Imaging.scale(image, width, height, interpolation, keepRatio, false);
    }

    public static BufferedImage scale(BufferedImage image, int width, int height, int interpolation) {
        return Imaging.scale(image, width, height, interpolation, true, false);
    }

    public static BufferedImage scale(BufferedImage image, int width, int height, int interpolation, boolean keepRatio, boolean fill) {
        if (width == 0 || height == 0 || image == null) {
            return null;
        }
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        double newWidth = width;
        double newHeight = height;
        if (keepRatio) {
            double ratioWidth = (double)image.getWidth() / (double)image.getHeight();
            double ratioHeight = (double)image.getHeight() / (double)image.getWidth();
            newHeight = newWidth * ratioHeight;
            if (newHeight > (double)height) {
                newHeight = height;
                newWidth = newHeight * ratioWidth;
            }
        }
        double scaleX = newWidth / (double)imageWidth;
        double scaleY = newHeight / (double)imageHeight;
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
        AffineTransformOp bilinearScaleOp = new AffineTransformOp(scaleTransform, interpolation);
        BufferedImage scaled = bilinearScaleOp.filter(image, Imaging.getCompatibleImage((int)newWidth, (int)newHeight));
        BufferedImage newImg = Imaging.getCompatibleImage((int)newWidth, (int)newHeight);
        if (newImg == null) {
            Game.log().log(Level.WARNING, "Image could not be scaled to {0} * {1}: {2}", new Object[]{newWidth, newHeight, image.toString()});
            return null;
        }
        Graphics2D g = (Graphics2D)newImg.getGraphics();
        g.drawImage((Image)scaled, 0, 0, null);
        g.dispose();
        if (fill && (newWidth != (double)width || newHeight != (double)height)) {
            BufferedImage wrapperImage = Imaging.getCompatibleImage(width, height);
            Graphics2D g2 = (Graphics2D)Objects.requireNonNull(wrapperImage).getGraphics();
            g2.drawImage((Image)newImg, (int)(((double)width - newWidth) / 2.0), (int)(((double)height - newHeight) / 2.0), null);
            g2.dispose();
            return wrapperImage;
        }
        return newImg;
    }

    public static BufferedImage setAlpha(Image img, float alpha) {
        if (img == null) {
            return null;
        }
        BufferedImage bimage = Imaging.getCompatibleImage(img.getWidth(null), img.getHeight(null));
        if (bimage == null) {
            return null;
        }
        Graphics2D g2d = bimage.createGraphics();
        g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        g2d.drawImage(img, 0, 0, null);
        g2d.dispose();
        return bimage;
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img == null) {
            return null;
        }
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = Imaging.getCompatibleImage(img.getWidth(null), img.getHeight(null));
        if (bimage == null) {
            return null;
        }
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        if (image == null || image.getWidth() == 0 || image.getHeight() == 0) {
            return image;
        }
        BufferedImage compatibleImg = Imaging.getCompatibleImage(image.getWidth(), image.getHeight());
        if (compatibleImg == null) {
            return null;
        }
        compatibleImg.createGraphics().drawImage((Image)image, 0, 0, null);
        return compatibleImg;
    }

    private static BufferedImage flipSprites(Spritesheet sprite, UnaryOperator<BufferedImage> flipFunction) {
        BufferedImage flippedSprite = Imaging.getCompatibleImage(sprite.getSpriteWidth() * sprite.getColumns(), sprite.getSpriteHeight() * sprite.getRows());
        if (flippedSprite == null) {
            return null;
        }
        Graphics2D g = (Graphics2D)flippedSprite.getGraphics();
        int index = 0;
        for (int column = 0; column < sprite.getColumns(); ++column) {
            for (int row = 0; row < sprite.getRows(); ++row) {
                g.drawImage((Image)flipFunction.apply(sprite.getSprite(index)), column * sprite.getSpriteWidth(), row * sprite.getSpriteHeight(), null);
                ++index;
            }
        }
        g.dispose();
        return flippedSprite;
    }
}

