/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util;

import de.gurkenlabs.litiengine.ILaunchable;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommandManager
implements ILaunchable {
    private static final Logger log = Logger.getLogger(CommandManager.class.getName());
    private final Map<String, Predicate<String[]>> commandConsumers = new ConcurrentHashMap<String, Predicate<String[]>>();
    private final ConsoleCommandProcessor commandListener = new ConsoleCommandProcessor();

    public void bind(String command, Predicate<String[]> commandConsumer) {
        if (this.commandConsumers.containsKey(command)) {
            throw new IllegalArgumentException("Cannot bind command " + command + " because it is already bound.");
        }
        this.commandConsumers.put(command, commandConsumer);
    }

    public boolean executeCommand(String command) {
        if (command == null || command.isEmpty()) {
            return false;
        }
        log.log(Level.FINE, "Command received: {0}", command);
        String[] arr = command.split(" ");
        if (arr.length == 0) {
            return false;
        }
        String keyword = arr[0];
        if (!this.commandConsumers.containsKey(keyword)) {
            return false;
        }
        return this.commandConsumers.get(keyword).test(arr);
    }

    @Override
    public void start() {
        this.commandListener.start();
    }

    @Override
    public void terminate() {
        this.commandListener.terminate();
    }

    private class ConsoleCommandProcessor
    extends Thread
    implements ILaunchable {
        ConsoleCommandProcessor() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            Scanner scanner = new Scanner(System.in);
            while (!ConsoleCommandProcessor.interrupted()) {
                String s = scanner.nextLine();
                CommandManager.this.executeCommand(s);
                try {
                    ConsoleCommandProcessor.sleep(10L);
                }
                catch (InterruptedException e) {
                    this.interrupt();
                    break;
                }
            }
            scanner.close();
        }

        @Override
        public void terminate() {
            this.interrupt();
        }
    }
}

