/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.input;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.GameListener;
import de.gurkenlabs.litiengine.ILaunchable;
import de.gurkenlabs.litiengine.input.Gamepad;
import de.gurkenlabs.litiengine.input.GamepadEvents;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;

public final class GamepadManager
extends GamepadEvents
implements ILaunchable {
    private static final Logger log = Logger.getLogger(GamepadManager.class.getName());
    private final Collection<GamepadAddedListener> gamepadAddedConsumer;
    private final Collection<GamepadRemovedListener> gamepadRemovedConsumer = ConcurrentHashMap.newKeySet();
    private final List<Gamepad> gamePads;
    private final Thread hotPlugThread;
    private int defaultgamepadId = -1;
    private boolean handleHotPluggedControllers;

    GamepadManager() {
        this.gamepadAddedConsumer = ConcurrentHashMap.newKeySet();
        this.gamePads = new CopyOnWriteArrayList<Gamepad>();
        this.hotPlugThread = new Thread(() -> {
            while (!Thread.interrupted()) {
                this.updateGamepads();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        });
        Game.addGameListener(new GameListener(){

            @Override
            public void terminated() {
                GamepadManager.this.hotPlugThread.interrupt();
            }
        });
        this.onAdded(pad -> {
            if (this.defaultgamepadId == -1) {
                this.defaultgamepadId = pad.getId();
                this.hookupToGamepad(pad);
            }
        });
        this.onRemoved(pad -> {
            if (this.defaultgamepadId == pad.getId()) {
                this.defaultgamepadId = -1;
                Gamepad newGamePad = this.current();
                if (newGamePad != null) {
                    this.defaultgamepadId = newGamePad.getId();
                    this.hookupToGamepad(newGamePad);
                }
            }
        });
        this.updateGamepads();
    }

    public void onAdded(GamepadAddedListener listener) {
        this.gamepadAddedConsumer.add(listener);
    }

    public void removeAddedListener(GamepadAddedListener listener) {
        this.gamepadAddedConsumer.remove(listener);
    }

    public void onRemoved(GamepadRemovedListener listener) {
        this.gamepadRemovedConsumer.add(listener);
    }

    public void removeRemovedListener(GamepadRemovedListener listener) {
        this.gamepadRemovedConsumer.remove(listener);
    }

    public List<Gamepad> getAll() {
        return this.gamePads;
    }

    public Gamepad current() {
        return this.get(0);
    }

    public Gamepad get(int index) {
        if (this.gamePads.isEmpty()) {
            return null;
        }
        return this.gamePads.get(index);
    }

    public Gamepad getById(int id) {
        for (Gamepad gamepad : this.gamePads) {
            if (gamepad.getId() != id) continue;
            return gamepad;
        }
        return null;
    }

    @Override
    public boolean isPressed(String gamepadComponent) {
        Gamepad current = this.current();
        return current != null && current.isPressed(gamepadComponent);
    }

    @Override
    public void onPoll(GamepadEvents.GamepadPollListener listener) {
        super.onPoll(listener);
        if (this.current() != null) {
            this.current().onPoll(listener);
        }
    }

    @Override
    public void onPressed(GamepadEvents.GamepadPressedListener listener) {
        super.onPressed(listener);
        if (this.current() != null) {
            this.current().onPressed(listener);
        }
    }

    @Override
    public void onReleased(GamepadEvents.GamepadReleasedListener listener) {
        super.onReleased(listener);
        if (this.current() != null) {
            this.current().onReleased(listener);
        }
    }

    @Override
    public void onPoll(String identifier, GamepadEvents.GamepadPollListener listener) {
        super.onPoll(identifier, listener);
        if (this.current() != null) {
            this.current().onPoll(identifier, listener);
        }
    }

    @Override
    public void onPressed(String identifier, GamepadEvents.GamepadPressedListener listener) {
        super.onPressed(identifier, listener);
        if (this.current() != null) {
            this.current().onPressed(identifier, listener);
        }
    }

    @Override
    public void onReleased(String identifier, GamepadEvents.GamepadReleasedListener listener) {
        super.onReleased(identifier, listener);
        if (this.current() != null) {
            this.current().onReleased(identifier, listener);
        }
    }

    @Override
    public void clearEventListeners() {
        super.clearEventListeners();
        if (this.current() != null) {
            this.current().clearEventListeners();
        }
    }

    @Override
    public void removePollListener(String identifier, GamepadEvents.GamepadPollListener listener) {
        super.removePollListener(identifier, listener);
        if (this.current() != null) {
            this.current().removePollListener(identifier, listener);
        }
    }

    @Override
    public void removePressedListener(String identifier, GamepadEvents.GamepadPressedListener listener) {
        super.removePressedListener(identifier, listener);
        if (this.current() != null) {
            this.current().removePressedListener(identifier, listener);
        }
    }

    @Override
    public void removeReleasedListener(String identifier, GamepadEvents.GamepadReleasedListener listener) {
        super.removeReleasedListener(identifier, listener);
        if (this.current() != null) {
            this.current().removeReleasedListener(identifier, listener);
        }
    }

    @Override
    public void removePollListener(GamepadEvents.GamepadPollListener listener) {
        super.removePollListener(listener);
        if (this.current() != null) {
            this.current().removePollListener(listener);
        }
    }

    @Override
    public void removePressedListener(GamepadEvents.GamepadPressedListener listener) {
        super.removePressedListener(listener);
        if (this.current() != null) {
            this.current().removePressedListener(listener);
        }
    }

    @Override
    public void removeReleasedListener(GamepadEvents.GamepadReleasedListener listener) {
        super.removeReleasedListener(listener);
        if (this.current() != null) {
            this.current().removeReleasedListener(listener);
        }
    }

    @Override
    public void start() {
        this.hotPlugThread.start();
    }

    @Override
    public void terminate() {
        for (int totalWait = 0; this.handleHotPluggedControllers && totalWait <= 40; ++totalWait) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        this.hotPlugThread.interrupt();
    }

    void remove(Gamepad gamepad) {
        if (gamepad == null) {
            return;
        }
        this.getAll().remove(gamepad);
        for (GamepadRemovedListener listener : this.gamepadRemovedConsumer) {
            listener.removed(gamepad);
        }
    }

    private static void hackTheShitOutOfJInput() {
        try {
            Field env = ControllerEnvironment.class.getDeclaredField("defaultEnvironment");
            env.setAccessible(true);
            Class<?> clazz = Class.forName("net.java.games.input.DefaultControllerEnvironment");
            Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
            for (Thread thread : threadSet) {
                String name = thread.getClass().getName();
                if (!name.equals("net.java.games.input.RawInputEventQueue$QueueThread")) continue;
                thread.interrupt();
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    log.log(Level.FINE, e.getMessage(), e);
                    Thread.currentThread().interrupt();
                }
            }
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            ctor.setAccessible(true);
            env.set(null, ctor.newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void hookupToGamepad(Gamepad pad) {
        for (Map.Entry entry : this.componentPollListeners.entrySet()) {
            for (EventListener listener : (Collection)entry.getValue()) {
                pad.onPoll((String)entry.getKey(), (GamepadEvents.GamepadPollListener)listener);
            }
        }
        for (Map.Entry entry : this.componentPressedListeners.entrySet()) {
            for (EventListener listener : (Collection)entry.getValue()) {
                pad.onPressed((String)entry.getKey(), (GamepadEvents.GamepadPressedListener)listener);
            }
        }
        for (Map.Entry entry : this.componentReleasedListeners.entrySet()) {
            for (EventListener listener : (Collection)entry.getValue()) {
                pad.onReleased((String)entry.getKey(), (GamepadEvents.GamepadReleasedListener)listener);
            }
        }
        for (EventListener listener : this.pollListeners) {
            pad.onPoll((GamepadEvents.GamepadPollListener)listener);
        }
        for (EventListener listener : this.pressedListeners) {
            pad.onPressed((GamepadEvents.GamepadPressedListener)listener);
        }
        for (EventListener listener : this.releasedListeners) {
            pad.onReleased((GamepadEvents.GamepadReleasedListener)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGamepads() {
        this.handleHotPluggedControllers = true;
        try {
            GamepadManager.hackTheShitOutOfJInput();
            for (int i = 0; i < ControllerEnvironment.getDefaultEnvironment().getControllers().length; ++i) {
                Gamepad existing;
                Controller controller = ControllerEnvironment.getDefaultEnvironment().getControllers()[i];
                Controller.Type type = controller.getType();
                if (type.equals(Controller.Type.KEYBOARD) || type.equals(Controller.Type.MOUSE) || type.equals(Controller.Type.UNKNOWN) || (existing = this.getById(i)) != null && existing.getName().equals(controller.getName())) continue;
                Gamepad newGamepad = new Gamepad(i, controller);
                this.getAll().add(newGamepad);
                for (GamepadAddedListener listener : this.gamepadAddedConsumer) {
                    listener.added(newGamepad);
                }
            }
        }
        catch (IllegalStateException e) {
            this.hotPlugThread.interrupt();
        }
        finally {
            this.handleHotPluggedControllers = false;
        }
    }

    @FunctionalInterface
    public static interface GamepadAddedListener
    extends EventListener {
        public void added(Gamepad var1);
    }

    @FunctionalInterface
    public static interface GamepadRemovedListener
    extends EventListener {
        public void removed(Gamepad var1);
    }
}

