/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.animation;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.graphics.ImageEffect;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.graphics.animation.Animation;
import de.gurkenlabs.litiengine.graphics.animation.AnimationListener;
import de.gurkenlabs.litiengine.graphics.animation.IAnimationController;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.util.Imaging;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class AnimationController
implements IAnimationController {
    private static final int MAX_IMAGE_EFFECTS = 20;
    private AffineTransform affineTransform;
    private final Map<String, Animation> animations = new ConcurrentHashMap<String, Animation>();
    private Animation currentAnimation;
    private Animation defaultAnimation;
    private boolean enabled = true;
    private final List<ImageEffect> imageEffects = new CopyOnWriteArrayList<ImageEffect>();
    private final List<AnimationListener> listeners = new CopyOnWriteArrayList<AnimationListener>();

    public AnimationController() {
    }

    public AnimationController(Animation defaultAnimation) {
        this();
        this.setDefault(defaultAnimation);
    }

    public AnimationController(Animation defaultAnimation, Animation ... animations) {
        this(defaultAnimation);
        if (animations != null && animations.length > 0) {
            for (Animation anim : animations) {
                if (anim == null) continue;
                this.animations.put(anim.getName(), anim);
            }
        }
    }

    public AnimationController(Spritesheet sprite) {
        this(sprite, true);
    }

    public AnimationController(Spritesheet sprite, boolean loop) {
        this(new Animation(sprite, loop, Resources.spritesheets().getCustomKeyFrameDurations(sprite)));
    }

    public static Animation flipAnimation(Animation anim, String newSpriteName) {
        BufferedImage flippedImage = Imaging.flipSpritesHorizontally(anim.getSpritesheet());
        Spritesheet flippedSpritesheet = Resources.spritesheets().load(flippedImage, newSpriteName, anim.getSpritesheet().getSpriteWidth(), anim.getSpritesheet().getSpriteHeight());
        return new Animation(flippedSpritesheet, anim.isLooping(), anim.getKeyFrameDurations());
    }

    @Override
    public void add(Animation animation) {
        if (animation == null) {
            return;
        }
        if (this.defaultAnimation == null) {
            this.defaultAnimation = animation;
        }
        this.animations.put(animation.getName(), animation);
    }

    @Override
    public void add(ImageEffect effect) {
        if (this.getImageEffects().size() >= 20) {
            return;
        }
        this.getImageEffects().add(effect);
        Collections.sort(this.getImageEffects());
    }

    @Override
    public void addListener(AnimationListener listener) {
        this.listeners.add(listener);
    }

    public void attach() {
        Game.loop().attach(this);
    }

    @Override
    public void clear() {
        this.animations.clear();
    }

    public void detach() {
        Game.loop().detach(this);
    }

    @Override
    public Animation get(String animationName) {
        if (animationName == null || animationName.isEmpty()) {
            return null;
        }
        return this.animations.getOrDefault(animationName, null);
    }

    @Override
    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    @Override
    public Collection<Animation> getAll() {
        return this.animations.values();
    }

    @Override
    public Animation getCurrent() {
        return this.currentAnimation;
    }

    @Override
    public BufferedImage getCurrentImage() {
        if (!this.isEnabled()) {
            return null;
        }
        Animation current = this.getCurrent();
        if (current == null || current.getSpritesheet() == null || current.getCurrentKeyFrame() == null) {
            return null;
        }
        String cacheKey = this.buildCurrentCacheKey();
        Optional opt = Resources.images().tryGet(cacheKey);
        if (opt.isPresent()) {
            return (BufferedImage)opt.get();
        }
        BufferedImage sprite = current.getSpritesheet().getSprite(current.getCurrentKeyFrame().getSpriteIndex());
        if (sprite == null) {
            return null;
        }
        for (ImageEffect effect : this.getImageEffects()) {
            sprite = effect.apply(sprite);
        }
        Resources.images().add(cacheKey, sprite);
        return sprite;
    }

    @Override
    public BufferedImage getCurrentImage(int width, int height) {
        if (this.getCurrentImage() == null) {
            return null;
        }
        String cacheKey = this.buildCurrentCacheKey() + "_" + width + "_" + height;
        Optional opt = Resources.images().tryGet(cacheKey);
        if (opt.isPresent()) {
            return (BufferedImage)opt.get();
        }
        return Imaging.scale(this.getCurrentImage(), width, height);
    }

    @Override
    public Animation getDefault() {
        if (this.defaultAnimation != null) {
            return this.defaultAnimation;
        }
        if (this.getAll().isEmpty()) {
            return null;
        }
        return this.getAll().stream().findFirst().orElse(null);
    }

    @Override
    public List<ImageEffect> getImageEffects() {
        this.removeFinishedImageEffects();
        return this.imageEffects;
    }

    @Override
    public boolean hasAnimation(String animationName) {
        if (animationName == null || animationName.isEmpty()) {
            return false;
        }
        return this.animations.containsKey(animationName);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isPlaying(String animationName) {
        return this.getCurrent() != null && this.getCurrent().getName() != null && this.getCurrent().getName().equalsIgnoreCase(animationName);
    }

    @Override
    public void play(String animationName) {
        if (this.isPlaying(animationName) || !this.hasAnimation(animationName)) {
            return;
        }
        Animation anim = this.get(animationName);
        if (anim == null) {
            return;
        }
        if (this.getCurrent() != null) {
            this.getCurrent().terminate();
        }
        this.currentAnimation = anim;
        this.currentAnimation.start();
        for (AnimationListener listener : this.listeners) {
            listener.played(this.getCurrent());
        }
    }

    @Override
    public void remove(Animation animation) {
        if (animation == null) {
            return;
        }
        this.animations.remove(animation.getName());
        if (this.currentAnimation != null && this.currentAnimation.equals(animation)) {
            this.currentAnimation = null;
        }
        if (this.getDefault() != null && this.getDefault().equals(animation)) {
            this.setDefault(this.getAll().stream().findFirst().orElse(null));
        }
    }

    @Override
    public void remove(ImageEffect effect) {
        if (effect == null) {
            return;
        }
        this.imageEffects.remove(effect);
    }

    @Override
    public void removeListener(AnimationListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setAffineTransform(AffineTransform affineTransform) {
        this.affineTransform = affineTransform;
    }

    @Override
    public void setDefault(Animation defaultAnimation) {
        if (this.defaultAnimation != null) {
            this.animations.remove(this.defaultAnimation.getName());
            if (this.currentAnimation != null && this.currentAnimation.equals(this.defaultAnimation)) {
                this.currentAnimation = null;
            }
        }
        this.defaultAnimation = defaultAnimation;
        if (this.defaultAnimation != null) {
            this.animations.put(this.defaultAnimation.getName(), this.defaultAnimation);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void update() {
        boolean playbackFinished;
        for (Animation animation : this.getAll()) {
            animation.update();
        }
        if (this.getCurrent() != null && this.getCurrent().isPaused()) {
            return;
        }
        boolean bl = playbackFinished = this.getCurrent() != null && !this.getCurrent().isPlaying();
        if (playbackFinished) {
            for (AnimationListener listener : this.listeners) {
                listener.finished(this.getCurrent());
            }
        }
        if (this.getCurrent() == null || playbackFinished) {
            if (this.getDefault() != null) {
                this.play(this.getDefault().getName());
            } else {
                this.currentAnimation = null;
            }
        }
    }

    protected String buildCurrentCacheKey() {
        if (this.getCurrent() == null || this.getCurrent().getCurrentKeyFrame() == null || this.getCurrent().getSpritesheet() == null) {
            return null;
        }
        StringBuilder cacheKey = new StringBuilder();
        cacheKey.append(this.getCurrent().getSpritesheet().hashCode());
        cacheKey.append('_');
        cacheKey.append(this.getCurrent().getCurrentKeyFrame().getSpriteIndex());
        cacheKey.append('_');
        this.getImageEffects().forEach(x -> cacheKey.append(x.getName().hashCode()));
        return cacheKey.toString();
    }

    private void removeFinishedImageEffects() {
        ArrayList<ImageEffect> effectsToRemove = new ArrayList<ImageEffect>();
        for (ImageEffect effect : this.imageEffects) {
            if (effect == null || !effect.timeToLiveReached()) continue;
            effectsToRemove.add(effect);
        }
        this.imageEffects.removeAll(effectsToRemove);
        this.imageEffects.removeAll(Collections.singleton(null));
    }
}

