/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public final class ShapeRenderer {
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);

    private ShapeRenderer() {
        throw new UnsupportedOperationException();
    }

    public static void render(Graphics2D g, Shape shape) {
        if (shape == null) {
            return;
        }
        g.fill(shape);
    }

    public static void render(Graphics2D g, Shape shape, double x, double y) {
        g.translate(x, y);
        ShapeRenderer.render(g, shape);
        g.translate(-x, -y);
    }

    public static void render(Graphics2D g, Shape shape, Point2D location) {
        ShapeRenderer.render(g, shape, location.getX(), location.getY());
    }

    public static void renderOutline(Graphics2D g, Shape shape) {
        ShapeRenderer.renderOutline(g, shape, DEFAULT_STROKE);
    }

    public static void renderOutline(Graphics2D g, Shape shape, float stroke) {
        ShapeRenderer.renderOutline(g, shape, new BasicStroke(stroke));
    }

    public static void renderOutline(Graphics2D g, Shape shape, Stroke stroke) {
        if (shape == null) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        g.setStroke(stroke);
        g.draw(shape);
        g.setStroke(oldStroke);
    }

    public static void renderTransformed(Graphics2D g, Shape shape, AffineTransform transform) {
        ShapeRenderer.render(g, transform.createTransformedShape(shape));
    }

    public static void renderOutlineTransformed(Graphics2D g, Shape shape, AffineTransform transform) {
        ShapeRenderer.renderOutlineTransformed(g, shape, transform, DEFAULT_STROKE);
    }

    public static void renderOutlineTransformed(Graphics2D g, Shape shape, AffineTransform transform, float stroke) {
        ShapeRenderer.renderOutlineTransformed(g, shape, transform, new BasicStroke(stroke));
    }

    public static void renderOutlineTransformed(Graphics2D g, Shape shape, AffineTransform transform, Stroke stroke) {
        if (transform == null) {
            ShapeRenderer.renderOutline(g, shape, stroke);
            return;
        }
        ShapeRenderer.renderOutline(g, transform.createTransformedShape(shape), stroke);
    }
}

