/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.EntityRenderEvent;
import de.gurkenlabs.litiengine.entities.EntityRenderListener;
import de.gurkenlabs.litiengine.entities.EntityRenderedListener;
import de.gurkenlabs.litiengine.entities.EntityYComparator;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.graphics.ImageRenderer;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.ShapeRenderer;
import de.gurkenlabs.litiengine.graphics.TextRenderer;
import de.gurkenlabs.litiengine.graphics.animation.IEntityAnimationController;
import de.gurkenlabs.litiengine.graphics.emitters.Emitter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public final class RenderEngine {
    public static final float DEFAULT_RENDERSCALE = 3.0f;
    private final EntityYComparator entityComparator = new EntityYComparator();
    private final List<EntityRenderedListener> entityRenderedListener = new CopyOnWriteArrayList<EntityRenderedListener>();
    private final List<EntityRenderListener> entityRenderListener = new CopyOnWriteArrayList<EntityRenderListener>();
    private float baseRenderScale = 3.0f;

    public RenderEngine() {
        if (Game.graphics() != null) {
            throw new UnsupportedOperationException("Never initialize a RenderEngine manually. Use Game.graphics() instead.");
        }
    }

    public void addEntityRenderedListener(EntityRenderedListener listener) {
        this.entityRenderedListener.add(listener);
    }

    public void removeEntityRenderedListener(EntityRenderedListener listener) {
        this.entityRenderedListener.remove(listener);
    }

    public void addEntityRenderListener(EntityRenderListener listener) {
        this.entityRenderListener.add(listener);
    }

    public void removeEntityRenderListener(EntityRenderListener listener) {
        this.entityRenderListener.remove(listener);
    }

    public float getBaseRenderScale() {
        return this.baseRenderScale;
    }

    public void setBaseRenderScale(float scale) {
        this.baseRenderScale = scale;
    }

    public void renderText(Graphics2D g, String text, double x, double y, boolean antialias) {
        if (text == null || text.isEmpty()) {
            return;
        }
        AffineTransform newT = new AffineTransform();
        AffineTransform oldT = g.getTransform();
        newT.scale(Game.world().camera().getRenderScale(), Game.world().camera().getRenderScale());
        newT.translate(Game.world().camera().getPixelOffsetX(), Game.world().camera().getPixelOffsetY());
        g.setTransform(newT);
        TextRenderer.render(g, text, x, y, antialias);
        g.setTransform(oldT);
    }

    public void renderText(Graphics2D g, String text, double x, double y) {
        this.renderText(g, text, x, y, false);
    }

    public void renderText(Graphics2D g, String text, Point2D location, boolean antialias) {
        this.renderText(g, text, location.getX(), location.getY(), antialias);
    }

    public void renderText(Graphics2D g, String text, Point2D location) {
        this.renderText(g, text, location, false);
    }

    public void renderShape(Graphics2D g, Shape shape) {
        this.renderShape(g, shape, false);
    }

    public void renderShape(Graphics2D g, Shape shape, boolean antialiasing) {
        this.renderShape(g, shape, antialiasing, 0.0);
    }

    public void renderShape(Graphics2D g, Shape shape, boolean antialiasing, double angle) {
        if (shape == null) {
            return;
        }
        Object hint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        AffineTransform t = new AffineTransform();
        if (Game.world().environment() == null || !Game.world().environment().isRendering()) {
            t.scale(Game.world().camera().getRenderScale(), Game.world().camera().getRenderScale());
        }
        t.translate(Game.world().camera().getPixelOffsetX(), Game.world().camera().getPixelOffsetY());
        t.rotate(Math.toRadians(angle), shape.getBounds().getX() + shape.getBounds().getWidth() * 0.5, shape.getBounds().getY() + shape.getBounds().getHeight() * 0.5);
        ShapeRenderer.renderTransformed(g, shape, t);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
    }

    public void renderOutline(Graphics2D g, Shape shape) {
        this.renderOutline(g, shape, new BasicStroke(1.0f / Game.world().camera().getRenderScale()));
    }

    public void renderOutline(Graphics2D g, Shape shape, boolean antialiasing) {
        this.renderOutline(g, shape, new BasicStroke(1.0f / Game.world().camera().getRenderScale()), antialiasing);
    }

    public void renderOutline(Graphics2D g, Shape shape, Stroke stroke) {
        this.renderOutline(g, shape, stroke, false);
    }

    public void renderOutline(Graphics2D g, Shape shape, Stroke stroke, boolean antialiasing) {
        this.renderOutline(g, shape, stroke, antialiasing, 0.0);
    }

    public void renderOutline(Graphics2D g, Shape shape, Stroke stroke, boolean antialiasing, double angle) {
        if (shape == null) {
            return;
        }
        Object hint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        AffineTransform t = new AffineTransform();
        if (Game.world().environment() == null || !Game.world().environment().isRendering()) {
            t.scale(Game.world().camera().getRenderScale(), Game.world().camera().getRenderScale());
        }
        t.translate(Game.world().camera().getPixelOffsetX(), Game.world().camera().getPixelOffsetY());
        t.rotate(Math.toRadians(angle), shape.getBounds().getX() + shape.getBounds().getWidth() * 0.5, shape.getBounds().getY() + shape.getBounds().getHeight() * 0.5);
        ShapeRenderer.renderOutlineTransformed(g, shape, t, stroke);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
    }

    public void renderImage(Graphics2D g, Image image, double x, double y) {
        this.renderImage(g, image, new Point2D.Double(x, y));
    }

    public void renderImage(Graphics2D g, Image image, Point2D location) {
        Point2D viewPortLocation = Game.world().camera().getViewportLocation(location);
        ImageRenderer.render(g, image, viewPortLocation.getX() * (double)Game.world().camera().getRenderScale(), viewPortLocation.getY() * (double)Game.world().camera().getRenderScale());
    }

    public void renderEntities(Graphics2D g, Collection<? extends IEntity> entities) {
        this.renderEntities(g, entities, true);
    }

    public void renderEntities(Graphics2D g, Collection<? extends IEntity> entities, boolean sort) {
        List entitiesToRender = entities.stream().filter(x -> Game.world().camera().getViewport().intersects(x.getBoundingBox()) || x instanceof Emitter).collect(Collectors.toList());
        if (sort) {
            try {
                Collections.sort(entitiesToRender, this.entityComparator);
            }
            catch (IllegalArgumentException e) {
                for (IEntity iEntity : entities) {
                    this.renderEntity(g, iEntity);
                }
                return;
            }
        }
        for (IEntity entity : entitiesToRender) {
            this.renderEntity(g, entity);
        }
    }

    public void renderEntity(Graphics2D g, IEntity entity) {
        BufferedImage img;
        if (entity == null) {
            return;
        }
        if (!this.canRender(entity)) {
            return;
        }
        EntityRenderEvent renderEvent = new EntityRenderEvent(g, entity);
        if (entity instanceof EntityRenderListener) {
            ((EntityRenderListener)((Object)entity)).rendering(renderEvent);
        }
        for (EntityRenderListener listener : this.entityRenderListener) {
            listener.rendering(renderEvent);
        }
        IEntityAnimationController<?> animationController = entity.animations();
        if (animationController != null && (img = animationController.getCurrentImage()) != null) {
            if (animationController.isAutoScaling()) {
                double ratioX = entity.getWidth() / (double)img.getWidth();
                double ratioY = entity.getHeight() / (double)img.getHeight();
                ImageRenderer.renderScaled(g, (Image)img, Game.world().camera().getViewportLocation(entity.getLocation()), ratioX, ratioY);
            } else {
                double deltaX = (entity.getWidth() - (double)img.getWidth()) / 2.0;
                double deltaY = (entity.getHeight() - (double)img.getHeight()) / 2.0;
                AffineTransform transform = animationController.getAffineTransform();
                if (transform != null) {
                    deltaX += ((double)img.getWidth() - (double)img.getWidth() * transform.getScaleX()) / 2.0;
                    deltaY += ((double)img.getHeight() - (double)img.getHeight() * transform.getScaleY()) / 2.0;
                }
                Point2D renderLocation = Game.world().camera().getViewportLocation(entity.getX() + deltaX, entity.getY() + deltaY);
                ImageRenderer.renderTransformed(g, img, renderLocation.getX(), renderLocation.getY(), transform);
                if (Game.config().debug().renderBoundingBoxes()) {
                    g.setColor(new Color(255, 0, 0, 50));
                    this.renderOutline(g, new Rectangle2D.Double(entity.getX(), entity.getY(), img.getWidth(), img.getWidth()));
                    ShapeRenderer.renderOutlineTransformed(g, (Shape)new Rectangle2D.Double(renderLocation.getX(), renderLocation.getY(), img.getWidth(), img.getWidth()), animationController.getAffineTransform(), 0.25f);
                }
            }
        }
        if (entity instanceof IRenderable) {
            ((IRenderable)((Object)entity)).render(g);
        }
        if (entity instanceof EntityRenderListener) {
            ((EntityRenderListener)((Object)entity)).rendered(renderEvent);
        }
        for (EntityRenderListener listener : this.entityRenderListener) {
            listener.rendered(renderEvent);
        }
        for (EntityRenderedListener listener : this.entityRenderedListener) {
            listener.rendered(renderEvent);
        }
    }

    public boolean canRender(IEntity entity) {
        if (entity.getRenderType() == RenderType.NONE) {
            return false;
        }
        if (entity instanceof EntityRenderListener && !((EntityRenderListener)((Object)entity)).canRender(entity)) {
            return false;
        }
        for (EntityRenderListener listener : this.entityRenderListener) {
            if (listener.canRender(entity)) continue;
            return false;
        }
        return true;
    }
}

