/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.graphics.ImageEffect;
import de.gurkenlabs.litiengine.util.Imaging;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class OverlayPixelsImageEffect
extends ImageEffect {
    private final Color color;

    public OverlayPixelsImageEffect(int ttl, Color color) {
        super(ttl, "OverlayPixels" + color.getRed() + color.getGreen() + color.getBlue());
        this.color = color;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        BufferedImage bimage = Imaging.getCompatibleImage(image.getWidth(null), image.getHeight(null));
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage((Image)image, 0, 0, null);
        bGr.drawImage((Image)Imaging.flashVisiblePixels(image, this.color), 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public Color getColor() {
        return this.color;
    }
}

