/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.environment.tilemap.IMapImage;
import de.gurkenlabs.litiengine.environment.tilemap.xml.ColorAdapter;
import de.gurkenlabs.litiengine.environment.tilemap.xml.CustomPropertyProvider;
import de.gurkenlabs.litiengine.environment.tilemap.xml.MissingImageException;
import de.gurkenlabs.litiengine.environment.tilemap.xml.TmxException;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.awt.Color;
import java.awt.Dimension;
import java.net.MalformedURLException;
import java.net.URL;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class MapImage
extends CustomPropertyProvider
implements IMapImage {
    @XmlAttribute
    private String source;
    @XmlAttribute(name="trans")
    @XmlJavaTypeAdapter(value=ColorAdapter.class)
    private Color transparentcolor;
    @XmlAttribute
    private int width;
    @XmlAttribute
    private int height;
    @XmlTransient
    private URL absolutePath;

    public MapImage() {
    }

    public MapImage(MapImage original) {
        super(original);
        if (original == null) {
            return;
        }
        this.source = original.getSource();
        if (original.getTransparentColor() != null) {
            this.transparentcolor = new Color(original.getTransparentColor().getRed(), original.getTransparentColor().getGreen(), original.getTransparentColor().getBlue(), original.getTransparentColor().getAlpha());
        }
        this.width = original.getWidth();
        this.height = original.getHeight();
        this.absolutePath = original.getAbsoluteSourcePath();
    }

    @Override
    public URL getAbsoluteSourcePath() {
        return this.absolutePath;
    }

    @Override
    public Dimension getDimension() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public Color getTransparentColor() {
        return this.transparentcolor;
    }

    @Override
    public void setTransparentColor(Color color) {
        this.transparentcolor = color;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    void finish(URL location) throws TmxException {
        super.finish(location);
        try {
            this.absolutePath = new URL(location, this.source);
        }
        catch (MalformedURLException e) {
            throw new MissingImageException(e);
        }
    }

    @Override
    public void setAbsoluteSourcePath(URL absolutePath) {
        this.absolutePath = absolutePath;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public boolean equals(Object anObject) {
        if (!(anObject instanceof IMapImage)) {
            return false;
        }
        if (this == anObject) {
            return true;
        }
        IMapImage other = (IMapImage)anObject;
        return this.getTransparentColor().equals(other.getTransparentColor()) && this.getAbsoluteSourcePath().equals(other.getAbsoluteSourcePath());
    }

    public int hashCode() {
        return this.getAbsoluteSourcePath().hashCode() ^ this.getTransparentColor().hashCode();
    }

    public String toString() {
        return this.getAbsoluteSourcePath().toExternalForm();
    }
}

