/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.environment.tilemap.ICustomProperty;
import de.gurkenlabs.litiengine.environment.tilemap.xml.CustomProperty;
import de.gurkenlabs.litiengine.util.io.URLAdapter;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomPropertyAdapter
extends XmlAdapter<PropertyList, Map<String, ICustomProperty>> {
    public Map<String, ICustomProperty> unmarshal(PropertyList v) {
        HashMap<String, ICustomProperty> map = new HashMap<String, ICustomProperty>(v.properties.size());
        for (Property property : v.properties) {
            CustomProperty prop = new CustomProperty(property.type, property.value != null ? property.value : property.contents);
            if (property.location != null) {
                prop.setValue(property.location);
            }
            map.put(property.name, prop);
        }
        return map;
    }

    public PropertyList marshal(Map<String, ICustomProperty> v) {
        if (v.isEmpty()) {
            return null;
        }
        ArrayList<Property> list = new ArrayList<Property>(v.size());
        for (Map.Entry<String, ICustomProperty> entry : v.entrySet()) {
            ICustomProperty property = entry.getValue();
            String value = property.getAsString();
            if (value == null || value.isEmpty()) continue;
            Property saved = new Property(entry.getKey(), property.getType());
            if (value.contains("\n")) {
                saved.contents = value;
            } else {
                saved.value = value;
            }
            saved.location = property.getAsFile();
            list.add(saved);
        }
        list.sort(null);
        return new PropertyList(list);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class PropertyList {
        @XmlElement(name="property")
        List<Property> properties;

        PropertyList() {
        }

        PropertyList(List<Property> properties) {
            this.properties = properties;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class Property
    implements Comparable<Property> {
        @XmlAttribute
        String name;
        @XmlAttribute
        String type;
        @XmlAttribute
        String value;
        @XmlValue
        String contents;
        @XmlTransient
        URL location;

        Property() {
        }

        Property(String name, String type) {
            this.name = name;
            this.type = type == null || !PropertyType.isValid(type) ? "string" : type;
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) throws MalformedURLException {
            if (this.type == null) {
                this.type = "string";
            }
            if (this.type.equals("file")) {
                this.location = ((URLAdapter)u.getAdapter(URLAdapter.class)).unmarshal(this.value);
            }
        }

        private void beforeMarshal(Marshaller m) throws URISyntaxException {
            if (this.type.equals("string")) {
                this.type = null;
            }
            if (this.location != null) {
                this.value = ((URLAdapter)m.getAdapter(URLAdapter.class)).marshal(this.location);
            }
        }

        @Override
        public int compareTo(Property o) {
            if (o == null) {
                return 1;
            }
            if (o.name == null && this.name == null) {
                return 0;
            }
            if (this.name == null) {
                return -1;
            }
            return this.name.compareTo(o.name);
        }
    }

    private static class PropertyType {
        private static final String STRING = "string";
        private static final String FLOAT = "float";
        private static final String INT = "int";
        private static final String BOOL = "bool";
        private static final String FILE = "file";
        private static final String COLOR = "color";

        private PropertyType() {
        }

        private static String[] values() {
            return new String[]{STRING, FLOAT, INT, BOOL, FILE, COLOR};
        }

        private static boolean isValid(String type) {
            for (String valid : PropertyType.values()) {
                if (!valid.equalsIgnoreCase(type)) continue;
                return true;
            }
            return false;
        }
    }
}

