/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ITile;
import de.gurkenlabs.litiengine.environment.tilemap.ITileLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ITileset;
import de.gurkenlabs.litiengine.environment.tilemap.MapOrientations;
import de.gurkenlabs.litiengine.environment.tilemap.StaggerIndex;
import de.gurkenlabs.litiengine.util.MathUtilities;
import java.awt.Point;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public final class MapUtilities {
    private MapUtilities() {
        throw new UnsupportedOperationException();
    }

    public static Rectangle2D getBounds(IMapObject ... objects) {
        double x = Double.MAX_VALUE;
        double y = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        for (IMapObject object : objects) {
            Rectangle2D bounds = object.getBoundingBox();
            x = Math.min(bounds.getX(), x);
            y = Math.min(bounds.getY(), y);
            maxX = Math.max(bounds.getX(), maxX);
            maxY = Math.max(bounds.getY(), maxY);
        }
        return new Rectangle2D.Double(x, y, maxX - x, maxY - y);
    }

    public static int getMaxMapId(IMap map) {
        int maxId = 0;
        if (map == null || map.getMapObjectLayers() == null) {
            return maxId;
        }
        for (IMapObjectLayer objectLayer : map.getMapObjectLayers()) {
            if (objectLayer == null || objectLayer.getMapObjects() == null) continue;
            for (IMapObject mapObject : objectLayer.getMapObjects()) {
                if (mapObject == null || mapObject.getId() <= maxId) continue;
                maxId = mapObject.getId();
            }
        }
        return maxId;
    }

    public static Rectangle2D getTileBoundingBox(IMap map, Rectangle2D box) {
        int minX = (int)MathUtilities.clamp(box.getX(), 0.0, map.getSizeInPixels().getWidth() - 1.0);
        int minY = (int)MathUtilities.clamp(box.getY(), 0.0, map.getSizeInPixels().getHeight() - 1.0);
        int maxX = (int)MathUtilities.clamp(box.getMaxX(), 0.0, map.getSizeInPixels().getWidth() - 1.0);
        int maxY = (int)MathUtilities.clamp(box.getMaxY(), 0.0, map.getSizeInPixels().getHeight() - 1.0);
        Point minTilePoint = map.getOrientation().getTile(minX, minY, map);
        Point maxTilePoint = map.getOrientation().getTile(maxX, maxY, map);
        int minTileX = map.getOrientation().getName().equals(MapOrientations.ISOMETRIC.getName()) ? minTilePoint.x : MathUtilities.clamp(minTilePoint.x, 0, map.getWidth() - 1);
        int minTileY = map.getOrientation().getName().equals(MapOrientations.ISOMETRIC.getName()) ? minTilePoint.y : MathUtilities.clamp(minTilePoint.y, 0, map.getHeight() - 1);
        int maxTileX = map.getOrientation().getName().equals(MapOrientations.ISOMETRIC.getName()) ? maxTilePoint.x : MathUtilities.clamp(maxTilePoint.x, 0, map.getWidth() - 1);
        int maxTileY = map.getOrientation().getName().equals(MapOrientations.ISOMETRIC.getName()) ? maxTilePoint.y : MathUtilities.clamp(maxTilePoint.y, 0, map.getWidth() - 1);
        Rectangle2D minTileBounds = map.getOrientation().getBounds(new Point(MathUtilities.clamp(minTileX, 0, map.getWidth() - 1), MathUtilities.clamp(minTileY, 0, map.getHeight() - 1)), map);
        Rectangle2D maxTileBounds = map.getOrientation().getBounds(new Point(MathUtilities.clamp(maxTileX, 0, map.getWidth() - 1), MathUtilities.clamp(maxTileY, 0, map.getHeight() - 1)), map);
        return new Rectangle2D.Double(minTileBounds.getX(), minTileBounds.getY(), maxTileBounds.getMaxX() - minTileBounds.getX(), maxTileBounds.getMaxY() - minTileBounds.getY());
    }

    public static Point getTile(Point2D mapLocation) {
        if (Game.world().environment() == null) {
            return new Point(-1, -1);
        }
        return MapUtilities.getTile(Game.world().environment().getMap(), mapLocation);
    }

    public static Point getTile(IMap map, Point2D mapLocation) {
        if (map == null) {
            return new Point(-1, -1);
        }
        return map.getOrientation().getTile(mapLocation, map);
    }

    public static boolean isStaggeredRowOrColumn(StaggerIndex staggerIndex, int index) {
        return staggerIndex == StaggerIndex.ODD && MathUtilities.isOddNumber(index) || staggerIndex == StaggerIndex.EVEN && !MathUtilities.isOddNumber(index);
    }

    public static Point2D getMapLocation(IMap map, Point tileLocation) {
        return new Point2D.Double((double)tileLocation.x * map.getTileSize().getWidth(), (double)tileLocation.y * map.getTileSize().getHeight());
    }

    public static List<ITile> getTilesByPixelLocation(IMap map, Point2D location) {
        ArrayList<ITile> tilesAtLocation = new ArrayList<ITile>();
        if (map.getTileLayers() == null || map.getTileLayers().isEmpty()) {
            return tilesAtLocation;
        }
        Point tileLocation = map.getOrientation().getTile(location, map);
        for (ITileLayer layer : map.getTileLayers()) {
            ITile tile = layer.getTile(tileLocation.x, tileLocation.y);
            if (tile == null) continue;
            tilesAtLocation.add(tile);
        }
        return tilesAtLocation;
    }

    public static ITile getTopMostTile(Point2D location) {
        if (Game.world().environment() == null || Game.world().environment().getMap() == null) {
            return null;
        }
        return MapUtilities.getTopMostTile(Game.world().environment().getMap(), location);
    }

    public static ITile getTopMostTile(IMap map, Point2D location) {
        if (map.getTileLayers() == null || map.getTileLayers().isEmpty()) {
            return null;
        }
        return MapUtilities.getTopMostTile(map.getOrientation().getTile(location, map));
    }

    public static ITile getTopMostTile(Point point) {
        if (Game.world().environment() == null || Game.world().environment().getMap() == null) {
            return null;
        }
        return MapUtilities.getTopMostTile(Game.world().environment().getMap(), point);
    }

    public static ITile getTopMostTile(IMap map, Point point) {
        Point tileLocation = point;
        ITile tile = null;
        for (int i = map.getTileLayers().size() - 1; i >= 0; --i) {
            ITile tileOfLayer = map.getTileLayers().get(i).getTile(tileLocation.x, tileLocation.y);
            if (tileOfLayer == null || tileOfLayer.getGridId() == 0) continue;
            tile = tileOfLayer;
            break;
        }
        return tile;
    }

    public static ITileset findTileSet(IMap map, ITile tile) {
        if (map == null || tile == null) {
            return null;
        }
        ITileset match = null;
        for (ITileset tileset : map.getTilesets()) {
            if (!tileset.containsTile(tile)) continue;
            match = tileset;
            break;
        }
        return match;
    }

    public static Path2D convertPolyshapeToPath(IMapObject mapObject) {
        List<Point2D> points;
        if (mapObject == null || !mapObject.isPolygon() && !mapObject.isPolyline()) {
            return null;
        }
        List<Point2D> list = points = mapObject.getPolyline() != null ? mapObject.getPolyline().getPoints() : mapObject.getPolygon().getPoints();
        if (points.isEmpty()) {
            return null;
        }
        Path2D.Float path = new Path2D.Float();
        ((Path2D)path).moveTo(mapObject.getLocation().getX(), mapObject.getLocation().getY());
        for (int i = 1; i < points.size(); ++i) {
            Point2D point = points.get(i);
            ((Path2D)path).lineTo(mapObject.getLocation().getX() + point.getX(), mapObject.getLocation().getY() + point.getY());
        }
        if (mapObject.isPolygon()) {
            path.closePath();
        }
        return path;
    }

    public static List<Point2D> getAbsolutePolyshapePoints(IMapObject mapObject) {
        if (mapObject.isPolygon()) {
            return mapObject.getPolygon().getAbsolutePoints(mapObject.getLocation());
        }
        if (mapObject.isPolyline()) {
            return mapObject.getPolyline().getAbsolutePoints(mapObject.getLocation());
        }
        return new ArrayList<Point2D>();
    }

    public static IMapObject findMapObject(IMap map, int id) {
        for (IMapObjectLayer layer : map.getMapObjectLayers()) {
            for (IMapObject obj : layer.getMapObjects()) {
                if (obj.getId() != id) continue;
                return obj;
            }
        }
        return null;
    }

    public static Rectangle2D getTileBoundingBox(Point2D mapLocation) {
        return MapUtilities.getTileBoundingBox(MapUtilities.getCurrentMap(), mapLocation);
    }

    public static Rectangle2D getTileBoundingBox(IMap map, Point2D mapLocation) {
        if (map == null) {
            return new Rectangle2D.Double();
        }
        return map.getOrientation().getEnclosingTileBounds(mapLocation, map);
    }

    public static Rectangle2D getTileBoundingBox(int x, int y) {
        return MapUtilities.getTileBoundingBox(MapUtilities.getCurrentMap(), x, y);
    }

    public static Rectangle2D getTileBoundingBox(IMap map, int x, int y) {
        return MapUtilities.getTileBoundingBox(map, new Point(x, y));
    }

    public static Rectangle2D getTileBoundingBox(Point tile) {
        return MapUtilities.getTileBoundingBox(MapUtilities.getCurrentMap(), tile);
    }

    public static Rectangle2D getTileBoundingBox(IMap map, Point tile) {
        if (map == null) {
            return new Rectangle2D.Double();
        }
        return map.getOrientation().getBounds(tile, map);
    }

    private static final IMap getCurrentMap() {
        if (Game.world().environment() == null) {
            return null;
        }
        return Game.world().environment().getMap();
    }
}

